<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:irm="urn:us:gov:ic:irm"
                xmlns:ntk="urn:us:gov:ic:ntk"
                xmlns:ddms="urn:us:mil:ces:metadata:ddms:4"
                xmlns:cve="urn:us:gov:ic:cve"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:dtf="date:time:function"
                xmlns:util="urn:us:gov:ic:irm:xsl:util"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->
<xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="util:containsAnyOfTheTokens"
                 as="xs:boolean">
		    <xsl:param name="attribute"/>
		    <xsl:param name="tokenList" as="xs:string+"/>
		    <xsl:value-of select="some $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:getMaxDay"
                 as="xs:string">
		    <xsl:param name="date" as="xs:dateTime"/>
		    <xsl:variable name="month" select="number(dtf:getMonth(string($date)))"/>
		    <xsl:choose>
			      <xsl:when test="$month = (1,3,5,7,8,10,12)">
				        <xsl:value-of select="31"/>
			      </xsl:when>
			      <xsl:when test="$month = (4,6,9,11)">
				        <xsl:value-of select="30"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="dtf:isLeapYear(string($date))">
						            <xsl:value-of select="29"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="28"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:isLeapYear"
                 as="xs:boolean">
		    <xsl:param name="date" as="xs:string"/>
		    <xsl:variable name="year" as="xs:integer" select="xs:integer(dtf:getYear($date))"/>
		    <xsl:choose>
			      <xsl:when test="$year mod 100 = 0">
				        <xsl:choose>
					          <xsl:when test="$year mod 400 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="$year mod 4 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:replaceDateTimeDay"
                 as="xs:dateTime">
		    <xsl:param name="dateTime" as="xs:dateTime"/>
		    <xsl:param name="newDayString" as="xs:string"/>
		    <xsl:variable name="beforeDay" select="substring(string($dateTime), 1, 8)"/>
		    <xsl:variable name="afterDay" select="substring(string($dateTime), 11)"/>
		    <xsl:value-of select="concat($beforeDay, $newDayString, $afterDay)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:getYear"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 1, 4)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:getMonth"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 6, 2)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:getDay" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 9, 2)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:getTimeZone"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateTimeEndingWithTimezone" as="xs:string"
                    select="concat('^.*(',$timeZoneRegEx,')$')"/>
		    <xsl:choose>
			      <xsl:when test="matches($dateString, $dateTimeEndingWithTimezone)">
				        <xsl:value-of select="replace($dateString, $dateTimeEndingWithTimezone, '$1')"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$defaultTimeZone"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:yearPortionHasFourDigits"
                 as="xs:boolean">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx" as="xs:string"
                    select="concat('^\d{4}(',$timeZoneRegEx,')?$')"/>
		    <xsl:variable name="dateStartingWithFourDigitYearRegEx" as="xs:string" select="'^\d{4}-.*$'"/>
		    <xsl:value-of select="matches($dateString, $dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx) or                            matches($dateString, $dateStartingWithFourDigitYearRegEx)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:removeTimeZone"
                 as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="replace($dateString, $timeZoneRegEx, '')"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:padDateTimeWithTemplate"
                 as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:param name="dateTemplateString" as="xs:string"/>
		    <xsl:value-of select="concat($dateString, substring($dateTemplateString, string-length(normalize-space($dateString))+1))"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="dtf:isAllowableDateTimeFormat"
                 as="xs:boolean">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="trimmedInput" as="xs:string" select="normalize-space($input)"/>

		    
		    <xsl:variable name="YYYY" as="xs:string" select="'^\d{4}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    
		    <xsl:variable name="YYYY-MM" as="xs:string" select="'^\d{4}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    
		    <xsl:variable name="YYYY-MM-DD" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    
		    <xsl:variable name="YYYY-MM-DDThh-mm" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    
		    <xsl:variable name="YYYY-MM-DDThh-mm-ss" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d{1,3})?(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <xsl:value-of select="    matches($trimmedInput, $YYYY) or    matches($trimmedInput, $YYYY-MM) or    matches($trimmedInput, $YYYY-MM-DD) or    matches($trimmedInput, $YYYY-MM-DDThh-mm) or    matches($trimmedInput, $YYYY-MM-DDThh-mm-ss)    "/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:startDate"
                 as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($dateString)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($dateString)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $startDateTimeTemplate)"/>
		    <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:endDate"
                 as="xs:dateTime">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($input)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($input)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $endDateTimeTemplate)"/>
		    <xsl:variable name="outputWithCorrectedDay"
                    select="dtf:replaceDateTimeDay($outputDate, dtf:getMaxDay($outputDate))"/>
		    <xsl:choose>
			      <xsl:when test="dtf:getDay($input)">
				        <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="concat($outputWithCorrectedDay, $timeZonePortion)"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:overlaps"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
		    <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$primaryStart &lt;= $secondaryEnd and $secondaryStart &lt;= $primaryEnd"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:isBefore"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
		    <xsl:value-of select="$primaryEnd &lt; $secondaryStart"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:isAfter"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
		    <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$secondaryEnd &lt; $primaryStart"/>
	  </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron" name="dtf:compareDateTimeRanges"
                 as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="operator" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryAndSecondayYearPortionsHaveFourDigits" as="xs:boolean"
                    select="dtf:yearPortionHasFourDigits($primary) and dtf:yearPortionHasFourDigits($secondary)"/>
		    <xsl:choose>
			      <xsl:when test="$primaryAndSecondayYearPortionsHaveFourDigits">
				        <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
				        <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
				        <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
				        <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
				        <xsl:choose>
					
					
					          <xsl:when test="($operator = 'lt' or $operator = '&lt;') and              (($primaryStart = $primaryEnd and $primaryStart = $secondaryStart) or              ($primaryStart = $primaryEnd and $primaryStart = $secondaryEnd) or              ($secondaryStart = $secondaryEnd and $primaryStart = $secondaryStart))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>

					          
					
					          <xsl:when test="($operator = 'gt' or $operator = '&gt;') and              (($primaryStart = $primaryEnd and $primaryEnd = $secondaryEnd) or              ($primaryStart = $primaryEnd and $primaryEnd = $secondaryStart) or              ($secondaryStart = $secondaryEnd and $primaryEnd = $secondaryEnd))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>

					          
					          <xsl:when test="$operator = 'lt' or $operator = '&lt;' or $operator = '&lt;='">
						            <xsl:value-of select="dtf:isBefore($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>

					          
					          <xsl:when test="$operator = 'gt' or $operator = '&gt;' or $operator = '&gt;='">
						            <xsl:value-of select="dtf:isAfter($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>

					          
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="false()"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>

   <!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="" schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:text> This is the root file for the IRM Schematron ruleset. It loads all of the
      required CVEs, declares some variables, and includes all of the Rule .sch files. </svrl:text>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xsd"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ism" prefix="ism"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:irm" prefix="irm"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ntk" prefix="ntk"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:mil:ces:metadata:ddms:4" prefix="ddms"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:cve" prefix="cve"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1999/XSL/Transform" prefix="xsl"/>
         <svrl:ns-prefix-in-attribute-values uri="date:time:function" prefix="dtf"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:irm:xsl:util" prefix="util"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00015</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00015</xsl:attribute>
            <svrl:text>
        [IRM-ID-00015][Error] If element ddms:dates exists without one of the attributes @ddms:created or @ddms:posted
        
        Human Readable: Every ddms:dates element must have at least one of @ddms:created or @ddms:posted.
    </svrl:text>
            <svrl:text>
        This rule checks that for each occurrence of ddms:dates that either @ddms:created or @ddms:posted is specified.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M62"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00016</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00016</xsl:attribute>
            <svrl:text>
        [IRM-ID-00016][Error] The permissible values for the year range are 1901 through the current
        year for attributes @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, 
        @ddms:posted, and @ddms:created.
        
        Human Readable: Dates must be after 1901 and in the past for @ddms:approvedOn, 
        @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, @ddms:posted, and @ddms:created.
    </svrl:text>
            <svrl:text>
        This pattern uses abstract rules to consolidate logic. For attributes, 
        we make sure that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M63"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00017</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00017</xsl:attribute>
            <svrl:text>
        [IRM-ID-00017][Error] The permissible values for the year range are 
        1901 through 9999 for attribute @ddms:validTil.
        
        Human Readable: @ddms:validTil must be after 1901.
    </svrl:text>
            <svrl:text>
        This pattern uses abstract rules to consolidate logic. For attributes, 
        we make sure that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M64"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00018</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00018</xsl:attribute>
            <svrl:text>
        [IRM-ID-00018][Error] Rule removed in V7.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M65"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00019</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00019</xsl:attribute>
            <svrl:text>
        '         [IRM-ID-00019][Warning] @ddms:approvedOn must not be later than @ddms:created and @ddms:posted.         '
    </svrl:text>
            <svrl:text>
        '         This rule uses an abstract pattern to consolidate logic.         It compares the date contained within the param @ddms:approvedOn to each date          contained within the param (@ddms:created,                                                 @ddms:posted) (using the comparison operator          contained in param '&lt;=') and makes sure that each comparison returns          true. Implementation details for the abstract pattern can be found in the          abstract pattern definition file located in the Lib directory.         '
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M66"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00020</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00020</xsl:attribute>
            <svrl:text>
        '         [IRM-ID-00020][Error] @ddms:infoCutOff must not be later than @ddms:created, and @ddms:posted.          '
    </svrl:text>
            <svrl:text>
        '         This rule uses an abstract pattern to consolidate logic.         It compares the date contained within the param @ddms:infoCutOff to each date          contained within the param (@ddms:created,                                                 @ddms:posted) (using the comparison operator          contained in param '&lt;=') and makes sure that each comparison returns          true. Implementation details for the abstract pattern can be found in the          abstract pattern definition file located in the Lib directory.         '
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M67"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00021</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00021</xsl:attribute>
            <svrl:text>
        '         [IRM-ID-00021][Warning] @ddms:validTil must not be earlier than         @ddms:created, @ddms:posted, @ddms:infoCutOff, and @ddms:approvedOn.          '
    </svrl:text>
            <svrl:text>
        '         This rule uses an abstract pattern to consolidate logic.         It compares the date contained within the param @ddms:validTil to each date          contained within the param (@ddms:created,                                                  @ddms:posted,                                                  @ddms:infoCutOff,                                                 @ddms:approvedOn) (using the comparison operator          contained in param '&gt;=') and makes sure that each comparison returns          true. Implementation details for the abstract pattern can be found in the          abstract pattern definition file located in the Lib directory.         '
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M68"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00022</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00022</xsl:attribute>
            <svrl:text>
        '         [IRM-ID-00022][Error] For any element ddms:temporalCoverage, child element ddms:start must          not be later than child element ddms:end.         '
    </svrl:text>
            <svrl:text>
        '         This rule uses an abstract pattern to consolidate logic.         It compares the date contained within the param ddms:start to each date          contained within the param (ddms:end) (using the comparison operator          contained in param '&lt;=') and makes sure that each comparison returns          true. Implementation details for the abstract pattern can be found in the          abstract pattern definition file located in the Lib directory.         '
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M69"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00023</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00023</xsl:attribute>
            <svrl:text>
        [IRM-ID-00023][Error] The permissible values for the year range are 0001 through 9999 
        for elements ddms:start and ddms:end.
        
        Human Readable: ddms:start and ddms:end must be positive integers less than 10,000.
    </svrl:text>
            <svrl:text>
        This pattern uses abstract rules to consolidate logic. For attributes, 
        we make sure that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M70"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00024</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00024</xsl:attribute>
            <svrl:text>
        [IRM-ID-00024][Warning] For elements ddms:start and ddms:end and attributes 
        @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, 
        @ddms:posted, @ddms:validTil, and @ddms:created, if the time designator (T) 
        is specified, it is recommended that time zone be specified.
        
        Human Readable: For elements and attributes of date-time types, if the 
        time designator (T) is specified, it is recommended that time zone be specified.
    </svrl:text>
            <svrl:text>
        The pattern applies to ddms:start and ddms:end elements, as well as any element that 
        contains one or more attributes @ddms:approvedOn, @ddms:infoCutOff, @ddms:posted, and 
        @ddms:created. It joins each of these attribute values, if present, into a larger 
        space-separated string. It then breaks this string into tokens at each space character. 
        If the value of the token contains the time zone designator (T), then it makes sure 
        that the token value matches the regular expression for a timeZone, which is defined 
        in the main schema file (IRM_XML.sch).
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M71"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00011</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00011</xsl:attribute>
            <svrl:text>
        [IRM-ID-00011][Error] Rule removed in V8 because it is covered by rule IRM-ID-00012.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M72"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00012</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00012</xsl:attribute>
            <svrl:text>
        [IRM-ID-00012][Error] There must exist exactly one element
        ddms:metacardInfo/ddms:identifier which specifies attribute
        @ddms:qualifier with a value of [IC-ID].
        
        Human Readable: The DDMS card must have a single IC-ID for itself.
    </svrl:text>
            <svrl:text> 
        We make sure that exactly one element ddms:metacardInfo/ddms:identifier
        specifies attribute @ddms:qualifier with a value of [IC-ID].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M73"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00013</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00013</xsl:attribute>
            <svrl:text>
        [IRM-ID-00013][Error] Rule removed in V8 because it is covered by rule IRM-ID-00014.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M74"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00014</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00014</xsl:attribute>
            <svrl:text>
        [IRM-ID-00014][Error] There must exist exactly one element
        ddms:resource/ddms:identifier which specifies attribute @ddms:qualifier
        with a value of [IC-ID].
        
        Human Readable: The DDMS card must have exactly one IC-ID for
        the referenced resource.
    </svrl:text>
            <svrl:text>
        We make sure that exactly one element ddms:resource/ddms:identifier
        specifies attribute @ddms:qualifier with a value of [IC-ID].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M75"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00029</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00029</xsl:attribute>
            <svrl:text>
        [IRM-ID-00029][Error]
        If element ddms:geospatialCoverage has attribute @ddms:precedence with a value of [Secondary],
        there must be at least one sibling element ddms:geospatialCoverage for which attribute 
        @ddms:precedence has a value of [Primary].
        
        Human Readable: If a secondary country code is provided, there must also be a primary country code. 
    </svrl:text>
            <svrl:text>
        If there is an element geospatialCoverage with attribute precedence
        specified with a value of [Secondary], then we make sure that there
        is at least one sibling geospatialCoverage element with attribute precedence
        specified with a value of [Primary].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M76"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00030</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00030</xsl:attribute>
            <svrl:text>
        [IRM-ID-00030][Error]
        If attribute @ddms:order is specified with integer value N, there must exist 
        other @ddms:order attributes with values 1 to N-1 with no duplicates.
        
        Human Readable: The values of attribute @ddms:order must be numbered 
        sequentially with no duplicates, beginning at 1.
    </svrl:text>
            <svrl:text>
        A list, named $orderList, is created containing the value of each order 
        attribute within the document after normalizing to remove extra white-space.
        If the total number of items in $orderList does not equal the number 
        of distinct values in $orderList, then a duplicate exists and we return
        false. Otherwise, we make sure that each number from 1 to N, where N 
        is the number of items in $orderList, is contained within $orderList.
        If each number is contained, then we return true. Otherwise, false.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M77"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00032</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00032</xsl:attribute>
            <svrl:text>
        [IRM-ID-00032][] Removed in V6.
    </svrl:text>
            <svrl:text/>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M78"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00035</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00035</xsl:attribute>
            <svrl:text>
		[IRM-ID-00035][Error] If MIN_DISCOVERABLE_OR_GREATER, element ddms:resource
		must specify at least one element ddms:language.
		
		Human Readable: If this IRM instance complies with the minimum
		discoverability rules, then the DDMS card must specify the language of
		the referenced resource.
	</svrl:text>
            <svrl:text>
		If MIN_DISCOVERABLE_OR_GREATER, we make sure that element ddms:resource
		specifies at least one element ddms:language.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M79"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00037</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00037</xsl:attribute>
            <svrl:text>
        [IRM-ID-00037][Error]
        For elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact, if the attribute ism:pocType is specified with
        a value of [ORCON], then the element ddms:phone must be specified with a
        non-whitespace value.
        
        Human Readable: Elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact must specify a phone number if they are 
        denoted as the POC for an ORIGINATOR CONTROLLED data.
    </svrl:text>
            <svrl:text>
        For elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact which specify attribute ism:pocType with a value
        of [ORCON], we make sure that a decendent element specifies element
        ddms:phone with a non-whitespace value.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M80"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00038</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00038</xsl:attribute>
            <svrl:text>
		[IRM-ID-00038][Error] If MIN_DISCOVERABLE_OR_GREATER, element ddms:resource
		must specify at least one element ddms:publisher.
		
		Human Readable: If this IRM instance complies with the minimum
		discoverability rules, then the DDMS card must specify the publisher of
		the referenced resource.
	</svrl:text>
            <svrl:text>
		If MIN_DISCOVERABLE_OR_GREATER, we make sure that element ddms:resource
		specifies at least one element ddms:publisher.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M81"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00039</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00039</xsl:attribute>
            <svrl:text>
		[IRM-ID-00039][Error] If MIN_DISCOVERABLE_OR_GREATER, element
		ddms:subjectCoverage must specify at least one element ddms:productionMetric.
		
		Human Readable: If this IRM instance complies with the minimum
		discoverability rules, then the DDMS card must specify a production metric
		of the referenced resource.
	</svrl:text>
            <svrl:text>
		If MIN_DISCOVERABLE_OR_GREATER, we make sure that element
		ddms:subjectCoverage specifies at least one element ddms:productionMetric.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M82"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00055</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00055</xsl:attribute>
            <svrl:text> [IRM-ID-00055][Error] If ddms:geospatialCoverage/@order is specified then
		there must be one and only one of ddms:geospatialIdentifier/ddms:countryCode or
		ddms:geospatialIdentifier/ddms:subDivisionCode. Human Readable: A single order value must be
		applied to one country code or one subdivision code but not to both. </svrl:text>
            <svrl:text> Make sure that there is only one ddms:countryCode or order ddms:subDivisionCode when
		ddms:geospatialCoverage uses the order attribute.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M83"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00056</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00056</xsl:attribute>
            <svrl:text>
        [IRM-ID-00056][Error] If MIN_DISCOVERABLE_OR_GREATER, element
        ddms:resource must specify at least one element ddms:title.
        
        Human Readable: If this IRM instance complies with the minimum
        discoverability rules, then the DDMS card must specify the title
        of the referenced resource.
    </svrl:text>
            <svrl:text>
        If MIN_DISCOVERABLE_OR_GREATER, we make sure that element
        ddms:resource specifies at least one element ddms:title.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M84"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00057</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00057</xsl:attribute>
            <svrl:text>
        [IRM-ID-00057][Error] Rule introduced in V8 and removed during V8 CR adjudication. Never part of a signed release. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M85"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00058</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00058</xsl:attribute>
            <svrl:text>
        [IRM-ID-00058][Error] Rule introduced in V8 and removed during V8 CR adjudication. Never part of a signed release. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M86"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00059</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00059</xsl:attribute>
            <svrl:text>
        [IRM-ID-00059][Error] If MIN_DISCOVERABLE_OR_GREATER, element
        ddms:resource must specify at least one element ddms:subjectCoverage.
        
        Human Readable: If this IRM instance complies with the minimum
        discoverability rules, then the DDMS card must specify a subjectCoverage
        of the referenced resource.
    </svrl:text>
            <svrl:text>
        If MIN_DISCOVERABLE_OR_GREATER, we make sure that element
        ddms:resource specifies at least one element ddms:subjectCoverage.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M87"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00060</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00060</xsl:attribute>
            <svrl:text>
        [IRM-ID-00060][Error] Rule introduced in V8 and removed during V8 CR adjudication. Never part of a signed release. 
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M88"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00061</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00061</xsl:attribute>
            <svrl:text>
        [IRM-ID-00061][Error] If MIN_DISCOVERABLE_OR_GREATER, element
        ddms:resource must specify at least one of the following elements:
        ddms:creator, ddms:publisher, ddms:contributor, or ddms:pointOfContact.
        
        Human Readable: If this IRM instance complies with the minimum
        discoverability rules, then the DDMS card must specify a creator,
        publisher, contributor, or pointOfContact for the referenced resource.
    </svrl:text>
            <svrl:text>
        If MIN_DISCOVERABLE_OR_GREATER, we make sure that element
        ddms:resource specifies at least one of the following elements:
        ddms:creator, ddms:publisher, ddms:contributor, or ddms:pointOfContact.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M89"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00062</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00062</xsl:attribute>
            <svrl:text>
        [IRM-ID-00062][Error] The value of an IC-ID identifier must follow 
        standardized convention.
    </svrl:text>
            <svrl:text>
        When IC-ID is specified as the value of ddms:identifier/@ddms:qualifier,
        @ddms:value should follow the regex [Gg][Uu][Ii][Dd][Ee]://[0-9]{4}/[A-Za-z0-9_\-\.]{1,43}
    </svrl:text>
            <svrl:text>
		This rule is duplicated in rule IC-EDH_ID_00007. Any change made here
		should also be made to that rule.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M90"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00063</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00063</xsl:attribute>
            <svrl:text>
        [IRM-ID-00063][Error] Element
        ddms:resource/ddms:creator/ddms:organization must specify attribute
        @ddms:acronym.
        
        Human Readable: The DDMS card must specify the creator organization of
        the referenced resource.
    </svrl:text>
            <svrl:text>
        We make sure that element ddms:resource/ddms:creator/ddms:organization
        exists and specifies attribute @ddms:acronym.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M91"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00064</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00064</xsl:attribute>
            <svrl:text>
        [IRM-ID-00064][Error] Element ddms:resource/ddms:dates must specify
        attribute @ddms:created.
        
        Human Readable: The DDMS card must specify the date on which the
        referenced resource was created.
    </svrl:text>
            <svrl:text>
        We make sure that element ddms:resource/ddms:dates exists and specifies
        attribute @ddms:created.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M92"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00065</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00065</xsl:attribute>
            <svrl:text>
        [IRM-ID-00065][Error] Attribute ddms:resource/ddms:dates/@ddms:created
        must be castable as an xs:dateTime type.
        
        Human Readable: The date on which the referenced resource was created
        must be a dateTime type.
    </svrl:text>
            <svrl:text>
        We make sure that attribute dms:resource/ddms:dates/@ddms:created is
        castable as an xs:dateTime type.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M93"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00066</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00066</xsl:attribute>
            <svrl:text>
        [IRM-ID-00066][Error] For element ddms:security/ddms:noticeList, element ism:Notice
        must specify attribute ism:externalNotice with a value of [true].
        
        Human Readable: Notices within a ddms:security element always refer
        to the referenced resource.
    </svrl:text>
            <svrl:text>
        For element ddms:security/ddms:noticeList/ism:Notice, we make sure that
        it specifies attribute ism:externalNotice with a value of [true].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M94"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00067</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00067</xsl:attribute>
            <svrl:text>
        [IRM-ID-00067][Error] For element ddms:security, element ntk:Access
        must specify attribute ntk:externalReference with a value of [true].
        
        Human Readable: NTK information within a ddms:security element always
        refers to the referenced resource.
    </svrl:text>
            <svrl:text>
        For element ddms:security/ntk:Access, we make sure that it specifies
        attribute ntk:externalReference with a value of [true].
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M95"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00068</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00068</xsl:attribute>
            <svrl:text>
        [IRM-ID-00068][Error]
        For element ddms:taskID, if attribute xlink:href exists, then the attribute must 
        have a non-null value.
    </svrl:text>
            <svrl:text>
        The normalize-spaced value of attribute xlink:href is checked to make sure the length of 
        the resulting string is greater than zero, which indicates non-whitespace content.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M96"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00069</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00069</xsl:attribute>
            <svrl:text>
        [IRM-ID-00069][Error]
        If attribute network is not specified for element ddms:taskID, which allows the 
        attribute, then attribute otherNetwork must not be specified for the same element.
    </svrl:text>
            <svrl:text>
        If element ddms:taskID does not have attribute network specified 
        and does have attribute otherNetwork specified, then return false.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M97"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00002</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00002</xsl:attribute>
            <svrl:text>
      [IRM-ID-00002][Error] For every attribute in the namespace
      [urn:us:gov:ic:irm] or [urn:us:mil:ces:metadata:ddms:4], a non-whitespace
      value must be specified.
    </svrl:text>
            <svrl:text>
        For each element which specifies an attribute in the IRM or DDMS
        namespace, we make sure that each attribute in the IRM or DDMS
        namespace specifies a non-whitespace value.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M98"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00025</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00025</xsl:attribute>
            <svrl:text>
        [IRM-ID-00025][Error] The attribute @ism:excludeFromRollup must not be specified for any element 
        in the namespace [urn:us:mil:ces:metadata:ddms:4] except security.
        
        Human Readable: The only DDMS 4.0 element whose ISM attributes are allowed to be 
        excluded from roll-up to the Resource element is ddms:security.
    </svrl:text>
            <svrl:text>
        For any element in the ddms namespace containing the ism:excludeFromRollup attribute, the rule
        will be satisfied if the name of the element is security.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M99"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00026</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00026</xsl:attribute>
            <svrl:text>
        [IRM-ID-00026][] Removed in V4.
    </svrl:text>
            <svrl:text/>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M100"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00040</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00040</xsl:attribute>
            <svrl:text>'[IRM-ID-00040][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:activity], then         attribute ism:classification must also be specified.'</svrl:text>
            <svrl:text>'         For each ddms:type element which specifies attribute ddms:qualifier with         a value of [urn:us:gov:ic:cvenum:irm:activity],         we make sure that attribute ism:classification is specified.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M101"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00041</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00041</xsl:attribute>
            <svrl:text>'[IRM-ID-00041][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:irm:intel:disciplines], then         attribute ism:classification must also be specified.'</svrl:text>
            <svrl:text>'         For each ddms:type element which specifies attribute ddms:qualifier with         a value of [urn:us:gov:ic:irm:intel:disciplines],         we make sure that attribtue ism:classification is specified.'</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M102"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00042</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00042</xsl:attribute>
            <svrl:text>'[IRM-ID-00042][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:intel:subdisciplines], then         attribute ism:classification must also be specified.'</svrl:text>
            <svrl:text>'         For each ddms:type element which specifies attribute ddms:qualifier with         a value of [urn:us:gov:ic:cvenum:irm:intel:subdisciplines],         we make sure that attribtue ism:classification is specified.'</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M103"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00043</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00043</xsl:attribute>
            <svrl:text>'[IRM-ID-00043][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechnique], then         attribute ism:classification must also be specified.'</svrl:text>
            <svrl:text>'         For each ddms:type element which specifies attribute ddms:qualifier with         a value of [urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechnique],         we make sure that attribtue ism:classification is specified.'</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M104"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00044</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00044</xsl:attribute>
            <svrl:text>'[IRM-ID-00044][Error]         If element ddms:type is specified with a qualifier of         [urn:us:gov:ic:irm:productline] then attribute ism:classification must         also be specified.'</svrl:text>
            <svrl:text>'         For each ddms:type element which specifies attribute ddms:qualifier with         a value of [urn:us:gov:ic:irm:productline], we make sure that attribtue         ism:classification is specified.'</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M105"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00045</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00045</xsl:attribute>
            <svrl:text>
        [IRM-ID-00045][Error] Element ddms:geospatialCoverage must have ISM 
        classification markings.
    </svrl:text>
            <svrl:text>
        For each ddms:geospatialCoverage element, we make sure that attribute
        ism:classification is specified.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M106"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00001</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00001</xsl:attribute>
            <svrl:text>'   [IRM-ID-00001][Error] If element ddms:countryCode has attribute @ddms:qualifier specified as   [urn:us:gov:ic:cvenum:irm:coverage:fips:digraph] then the value of attribute @ddms:value must   be in CVEnumIRMCoverageFIPSDigraph.xml.      Human Readable: FIPS CountryCodes must in the the FIPS CVE.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:value is contained in the parameter $coverageFipsDigraphList. The parameter   @ddms:value is relative in scope to the parameter ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:fips:digraph']. The value for the parameter    $coverageFipsDigraphList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M107"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00003</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00003</xsl:attribute>
            <svrl:text>'   [IRM-ID-00003][Error] If element ddms:countryCode has attribute @ddms:qualifier specified as   [urn:us:gov:ic:cvenum:irm:coverage:iso3166:trigraph] then the value of attribute @ddms:value must   be in CVEnumIRMCoverageISO3166trigraph.xml.      Human Readable: ISO trigraph CountryCodes must in the the ISO trigraph CVE.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:value is contained in the parameter $coverageIso3166TrigraphList. The parameter   @ddms:value is relative in scope to the parameter ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166:trigraph']. The value for the parameter    $coverageIso3166TrigraphList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M108"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00004</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00004</xsl:attribute>
            <svrl:text>
        [IRM-ID-00004][] Removed in V4.
    </svrl:text>
            <svrl:text/>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M109"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00005</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00005</xsl:attribute>
            <svrl:text>'   [IRM-ID-00005][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639:digraph] then the value of attribute    @ddms:value must be in CVEnumIRMISO639Digraph.xml and no country code portion may    be specified in the ddms:language element value.      Human Readable: ISO 639 digraph language codes must be in the ISO 639 digraph CVE.    '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:value is contained in the parameter $iso639DigraphList. The parameter   @ddms:value is relative in scope to the parameter ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639:digraph']. The value for the parameter    $iso639DigraphList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M110"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00006</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00006</xsl:attribute>
            <svrl:text>'   [IRM-ID-00006][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639-2:trigraph] then the value of    attribute @ddms:value must be in CVEnumIRMISO639-2Trigraph.xml and no country    code portion may be specified in the ddms:value attribute value.      Human Readable: ISO 639-2 trigraph language codes must be in the ISO 639-2    trigraph CVE.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:value is contained in the parameter $iso639-2TrigraphList. The parameter   @ddms:value is relative in scope to the parameter ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-2:trigraph']. The value for the parameter    $iso639-2TrigraphList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M111"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00007</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00007</xsl:attribute>
            <svrl:text>'   [IRM-ID-00007][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639-3:trigraph] then the value of    attribute @ddms:value must be in CVEnumIRMISO639-3Trigraph.xml and no country code    portion may be specified in the ddms:value attribute value.      Human Readable: ISO 639-3 trigraph language codes must in the the ISO 639-3    trigraph CVE.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:value is contained in the parameter $iso639-3TrigraphList. The parameter   @ddms:value is relative in scope to the parameter ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-3:trigraph']. The value for the parameter    $iso639-3TrigraphList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M112"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00008</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00008</xsl:attribute>
            <svrl:text>
        [IRM-ID-00008][Error] If element ddms:language has the attribute @ddms:qualifier 
        value of [RFC1766] then the language code portion of the @ddms:value attribute 
        value must be in CVEnumIRMISO639Digraph.xml and the country code portion, if 
        present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
        
        Human Readable: RFC1766 language codes must comply with the RFC by using 
        parts from ISO 639 Digraph and ISO 3166 Digraph.
    </svrl:text>
            <svrl:text>
        Finds ddms:language element and checks its qualifier attribute for a value of
        [RFC4646]. If this value is found it will ensure that the value of the element's ddms:value 
        attribute exists in the CVEnumIRMISO639Digraph.xml enumeration file represented by the 
        $iso639DigraphList variable and country code portions (denoted by '-' separation) must be 
        in CVEnumIRMCoverageISO3166Digraph.xml enumeration file represented by the 
        $coverageIso3166DigraphList variable.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M113"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00009</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00009</xsl:attribute>
            <svrl:text>
        [IRM-ID-00009][Error] If element ddms:language has the attribute @ddms:qualifier 
        value of [RFC3066] then the language code portion of the @ddms:value attribute 
        value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
        
        Human Readable: RFC3066 language codes must comply with the RFC by using parts 
        from ISO 639 Digraph, 639-2 Trigraph, and ISO 3166 Digraph.
    </svrl:text>
            <svrl:text>
        Finds ddms:language elements and checks its qualifier attribute for a value of
        [RFC3066]. If this value is found it will ensure that the value of the element's ddms:value 
        attribute exists in the CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        enumeration files represented by the $iso639DigraphList or $iso639-2TrigraphList variables. 
        Country code portions (denoted by '-' separation) must be in the
        CVEnumIRMCoverageISO3166Digraph.xml enumeration file represented by the 
        $coverageIso3166DigraphList variable.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M114"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00010</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00010</xsl:attribute>
            <svrl:text>
        [IRM-ID-00010][Error] If element ddms:language has the attribute @ddms:qualifier 
        value of [RFC4646] then the language code portion of the @ddms:value attribute 
        value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
        
        Human Readable: RFC4646 language codes must comply with the RFC by using parts 
        from ISO 639 Digraph or ISO 639-2 Trigraph and ISO 3166 Digraph.
    </svrl:text>
            <svrl:text>
        Finds ddms:language elements and checks its qualifier attribute for a value of
        [RFC4646]. If this value is found it will ensure that the value of the element's ddms:value 
        attribute exists in the CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        enumeration files represented by the $iso639DigraphList or $iso639-2TrigraphList variables. 
        Country code portions (denoted by '-' separation) must be in the 
        CVEnumIRMCoverageISO3166Digraph.xml enumeration file represented by the 
        $coverageIso3166TrigraphList variable.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M115"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00027</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00027</xsl:attribute>
            <svrl:text>
        [IRM-ID-00027][] Removed in V6.
    </svrl:text>
            <svrl:text/>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M116"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00028</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00028</xsl:attribute>
            <svrl:text>
        [IRM-ID-00028][] Removed in V6.
    </svrl:text>
            <svrl:text/>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M117"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00031</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00031</xsl:attribute>
            <svrl:text>'   [IRM-ID-00031][Error]   The element ddms:countryCode must have the attribute ddms:qualifier specified   with a value in CVEnumIRMCompoundCountryCodeQualifierType.xml.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:qualifier is contained in the parameter $compoundCountryCodeQualifierTypeList. The parameter   @ddms:qualifier is relative in scope to the parameter ddms:countryCode. The value for the parameter    $compoundCountryCodeQualifierTypeList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M118"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00033</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00033</xsl:attribute>
            <svrl:text>'   [IRM-ID-00033][Error] If element ddms:mimeType is specified, it must have a value from CVEnumIRMMimeType.xml.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter . is contained in the parameter $mimeTypeList. The parameter   . is relative in scope to the parameter ddms:mimeType. The value for the parameter    $mimeTypeList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M119"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00034</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00034</xsl:attribute>
            <svrl:text>'   [IRM-ID-00034][Error] For element ddms:language, attribute ddms:qualifier must have a    value in CVEnumIRMCompoundLanguageQualifierType.xml.   '</svrl:text>
            <svrl:text>'   This rule uses an abstract pattern to consolidate logic. It checks that the   value in parameter @ddms:qualifier is contained in the parameter $compoundLanguageQualifierTypeList. The parameter   @ddms:qualifier is relative in scope to the parameter ddms:language. The value for the parameter    $compoundLanguageQualifierTypeList is a variable defined in the main document (IRM_XML.sch), which reads    values from a specific CVE file.   '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M120"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00046</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00046</xsl:attribute>
            <svrl:text>'         [IRM-ID-00046][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechniques]         the attribute @ddms:type must be in CVEnumIRMIntelSubDisciplineTechniques.xml.                  Human Readable: Intel Sub Discipline Techniques must be in the          CVEnumIRMIntelSubDisciplineTechniques CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $subDisciplineTechniquesList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechniques']. The value for the parameter          $subDisciplineTechniquesList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M121"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00047</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00047</xsl:attribute>
            <svrl:text>'         [IRM-ID-00047][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:subdisciplines]         the attribute @ddms:value must be in CVEnumIRMIntelSubDisciplines.xml.                  Human Readable: Intel Sub Disciplines must be in the          CVEnumIRMIntelSubDisciplines CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $intelSubDisciplinesList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplines']. The value for the parameter          $intelSubDisciplinesList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M122"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00048</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00048</xsl:attribute>
            <svrl:text>'         [IRM-ID-00048][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:disciplines]         the attribute @ddms:value must be in CVEnumIRMIntelDisciplines.xml.                  Human Readable: Intel Disciplines must be in the          CVEnumIRMIntelDisciplines CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $intelDisciplinesList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:disciplines']. The value for the parameter          $intelDisciplinesList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M123"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00049</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00049</xsl:attribute>
            <svrl:text>'         [IRM-ID-00049][Error]         If element ddms:subDivisionCode has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:coverage:iso3166-2:subcountry]         the attribute @ddms:value must be in CVEnumIRMCoverageISO3166-2SubCountry.xml.                  Human Readable: ISO 3166-2 Sub Country codes must be in the           CVEnumIRMCoverageISO3166-2SubCountry CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $coverageIso3166-2SubCountryList. The parameter         @ddms:value is relative in scope to the parameter ddms:subDivisionCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166-2:subcountry']. The value for the parameter          $coverageIso3166-2SubCountryList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M124"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00050</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00050</xsl:attribute>
            <svrl:text>'         [IRM-ID-00050][Error]         For element ddms:productionsMetrics, attribute @ddms:subject must          be in CVEnumIRMProductionMetricsSubject.xml.                  Human Readable: Production Metric Subjects must be in the           CVEnumIRMProductionMetricsSubject CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:subject is contained in the parameter $productionMetricsSubjectList. The parameter         @ddms:subject is relative in scope to the parameter ddms:productionMetric[@ddms:subject]. The value for the parameter          $productionMetricsSubjectList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M125"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00051</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00051</xsl:attribute>
            <svrl:text>'         [IRM-ID-00051][Error]         For element ddms:productionsMetrics, attribute @ddms:coverage must          be in CVEnumIRMProductionMetricsCoverage.xml.                  Human Readable: Production Metric Coverage values must be in the           CVEnumIRMProductionMetricsCoverage CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:coverage is contained in the parameter $productionMetricsCoverageList. The parameter         @ddms:coverage is relative in scope to the parameter ddms:productionMetric[@ddms:coverage]. The value for the parameter          $productionMetricsCoverageList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M126"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00052</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00052</xsl:attribute>
            <svrl:text>'         [IRM-ID-00052][Error]         If element ddms:organization has attribute @ddms:acronym specified,         then the value must be in CVEnumIRMAgencyAcronym.xml.                  Human Readable: Agency acronyms must be in the CVEnumIRMAgencyAcronym CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:acronym is contained in the parameter $agencyAcronymList. The parameter         @ddms:acronym is relative in scope to the parameter ddms:organization[@ddms:acronym]. The value for the parameter          $agencyAcronymList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M127"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00053</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00053</xsl:attribute>
            <svrl:text>'         [IRM-ID-00053][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:activity]         the attribute @ddms:type must be in CVEnumIRMActivity.xml.                  Human Readable: Activity must be in the          CVEnumIRMActivity CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $activityList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:activity']. The value for the parameter          $activityList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M128"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00054</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00054</xsl:attribute>
            <svrl:text>'         [IRM-ID-00054][Error]         If element ddms:geospatialCoverage has attribute @ddms:precedence specified,         then the value must be in CVEnumIRMCoveragePrecedence.xml.                  Human Readable: ddms:geospatialCoverage/@ddms:precedence must be in the CVEnumIRMCoveragePrecedence CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:precedence is contained in the parameter $coveragePrecedenceList. The parameter         @ddms:precedence is relative in scope to the parameter ddms:geospatialCoverage[@ddms:precedence]. The value for the parameter          $coveragePrecedenceList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M129"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00070</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00070</xsl:attribute>
            <svrl:text>'         [IRM-ID-00070][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:executableindicator]         the attribute @ddms:type must be in CVEnumIRMExecutableIndicator.xml.                  Human Readable: Executable Indicator Value must be in the          CVEnumIRMExecutableIndicator CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $executableIndicatorList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:executableindicator']. The value for the parameter          $executableIndicatorList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M130"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00071</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00071</xsl:attribute>
            <svrl:text>'         [IRM-ID-00071][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:maliciouscodeindicator]         the attribute @ddms:type must be in CVEnumIRMMaliciousCodeIndicator.xml.                  Human Readable: Malicious Code Indicator values must be in the          CVEnumIRMMaliciousCodeIndicator CVE.         '</svrl:text>
            <svrl:text>'         This rule uses an abstract pattern to consolidate logic. It checks that the         value in parameter @ddms:value is contained in the parameter $maliciousCodeIndicatorList. The parameter         @ddms:value is relative in scope to the parameter ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:maliciouscodeindicator']. The value for the parameter          $maliciousCodeIndicatorList is a variable defined in the main document (IRM_XML.sch), which reads          values from a specific CVE file.         '</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M131"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IRM-ID-00036</xsl:attribute>
            <xsl:attribute name="name">IRM-ID-00036</xsl:attribute>
            <svrl:text>
		[IRM-ID-00036][Error] For any element, if any attribute is specified with the 
		xlink namespace [http://www.w3.org/1999/xlink], then attributes @xlink:type and/or
		@xlink:href must be specified.
		
		Human Readable: If any XLink attributes are specified for an element, then the type
		and/or URL of the link must also be specified.
	</svrl:text>
            <svrl:text>
		Makes sure that for each element that has any attribute in the xlink namespace has
		either xlink:type or xlink:href specified.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M132"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
<xsl:param name="IRM_COMPLIES_WITH"
              select="irm:ICResourceMetadataPackage/@irm:compliesWith"/>
   <xsl:param name="MIN_DISCOVERABLE_OR_GREATER"
              select="util:containsAnyOfTheTokens($IRM_COMPLIES_WITH, ('MIN_DISCOVERABLE'))"/>
   <xsl:param name="MIN_ACCESSIBLE_OR_GREATER"
              select="$MIN_DISCOVERABLE_OR_GREATER or util:containsAnyOfTheTokens($IRM_COMPLIES_WITH, ('MIN_ACCESSIBLE'))"/>
   <xsl:param name="agencyAcronymList"
              select="document('../../CVE/IRM/CVEnumIRMAgencyAcronym.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="compliesWithList"
              select="document('../../CVE/IRM/CVEnumIRMCompliesWith.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="coverageFipsDigraphList"
              select="document('../../CVE/IRM/CVEnumIRMCoverageFIPSDigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="coverageIso3166DigraphList"
              select="document('../../CVE/IRM/CVEnumIRMCoverageISO3166Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="coverageIso3166TrigraphList"
              select="document('../../CVE/IRM/CVEnumIRMCoverageISO3166Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="coverageIso3166-2SubCountryList"
              select="document('../../CVE/IRM/CVEnumIRMCoverageISO3166-2SubCountry.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639DigraphList"
              select="document('../../CVE/IRM/CVEnumIRMISO639Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639-2TrigraphList"
              select="document('../../CVE/IRM/CVEnumIRMISO639-2Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="iso639-3TrigraphList"
              select="document('../../CVE/IRM/CVEnumIRMISO639-3Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <xsl:param name="mimeTypeList"
              select="document('../../CVE/IRM/CVEnumIRMMimeType.xml')//cve:Value"/>
   <xsl:param name="compoundCountryCodeQualifierTypeList"
              select="document('../../CVE/IRM/CVEnumIRMCompoundCountryCodeQualifierType.xml')//cve:Value"/>
   <xsl:param name="compoundLanguageQualifierTypeList"
              select="document('../../CVE/IRM/CVEnumIRMCompoundLanguageQualifierType.xml')//cve:Value"/>
   <xsl:param name="subDisciplineTechniquesV1List"
              select="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplineTechniques.xml')//cve:Value"/>
   <xsl:param name="subDisciplineTechniquesList"
              select="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplineTechniques.xml')//cve:Value"/>
   <xsl:param name="intelSubDisciplinesList"
              select="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplines.xml')//cve:Value"/>
   <xsl:param name="intelDisciplinesList"
              select="document('../../CVE/IRM/CVEnumIRMIntelDisciplines.xml')//cve:Value"/>
   <xsl:param name="productionMetricsSubjectList"
              select="document('../../CVE/IRM/CVEnumIRMProductionMetricsSubject.xml')//cve:Value"/>
   <xsl:param name="productionMetricsCoverageList"
              select="document('../../CVE/IRM/CVEnumIRMProductionMetricsCoverage.xml')//cve:Value"/>
   <xsl:param name="activityList"
              select="document('../../CVE/IRM/CVEnumIRMActivity.xml')//cve:Value"/>
   <xsl:param name="executableIndicatorList"
              select="document('../../CVE/IRM/CVEnumIRMExecutableIndicator.xml')//cve:Value"/>
   <xsl:param name="maliciousCodeIndicatorList"
              select="document('../../CVE/IRM/CVEnumIRMMaliciousCodeIndicator.xml')//cve:Value"/>
   <xsl:param name="coveragePrecedenceList"
              select="document('../../CVE/IRM/CVEnumIRMCoveragePrecedence.xml')//cve:Value"/>
   <xsl:param name="currentYear" select="year-from-dateTime(current-dateTime())"/>
   <xsl:param name="timeZoneRegEx" select="'Z|[\+-]\d{2}:\d{2}'"/>
   <xsl:param name="endsWithTimeZoneRegEx" select="concat('^.*',$timeZoneRegEx,'$')"/>
   <xsl:param name="startDateTimeTemplate" select="'0001-01-01T00:00:00.000'"/>
   <xsl:param name="endDateTimeTemplate" select="'9999-12-01T23:59:59.999'"/>
   <xsl:param name="defaultTimeZone" select="'Z'"/>

   <!--PATTERN IRM-ID-00015-->


	<!--RULE -->
<xsl:template match="ddms:dates" priority="1000" mode="M62">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:dates"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ddms:created or @ddms:posted"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ddms:created or @ddms:posted">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
    	    [IRM-ID-00015][Error] Every ddms:date must have at least one of @ddms:created or @ddms:posted.
    	</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M62"/>
   <xsl:template match="@*|node()" priority="-2" mode="M62">
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00016-->


	<!--RULE -->
<xsl:template match="*[@ddms:approvedOn |                        @ddms:dateProcessed |                        @ddms:receivedOn |                        @ddms:posted |                         @ddms:created |                         @ddms:infoCutOff]"
                 priority="1000"
                 mode="M63">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@ddms:approvedOn |                        @ddms:dateProcessed |                        @ddms:receivedOn |                        @ddms:posted |                         @ddms:created |                         @ddms:infoCutOff]"/>
      <xsl:variable name="minYear" select="1901"/>
      <xsl:variable name="maxYear" select="$currentYear"/>
      <xsl:variable name="dateList"
                    select="             (string(@ddms:approvedOn),             string(@ddms:dateProcessed),             string(@ddms:receivedOn),             string(@ddms:posted),             string(@ddms:created),              string(@ddms:infoCutOff))"/>
      <xsl:variable name="errMsg"
                    select="'             [IRM-ID-00016][Error] The permissible values for the year range are 1901 through the current             year for attributes @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff,              @ddms:posted, and @ddms:created.                          Human Readable: Dates must be after 1901 and in the past for @ddms:approvedOn,              @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, @ddms:posted, and @ddms:created.             '"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="        every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies         if(not(dtf:isAllowableDateTimeFormat(string($date))))         then true()         else          xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear          and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies if(not(dtf:isAllowableDateTimeFormat(string($date)))) then true() else xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M63"/>
   <xsl:template match="@*|node()" priority="-2" mode="M63">
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00017-->


	<!--RULE -->
<xsl:template match="*[@ddms:validTil]" priority="1000" mode="M64">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@ddms:validTil]"/>
      <xsl:variable name="minYear" select="1901"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateList" select="(string(@ddms:validTil))"/>
      <xsl:variable name="errMsg"
                    select="'             [IRM-ID-00017][Error] The permissible values for the year range are              1901 through 9999 for attribute @ddms:validTil.                          Human Readable: @ddms:validTil must be after 1901.             '"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="        every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies         if(not(dtf:isAllowableDateTimeFormat(string($date))))         then true()         else          xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear          and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies if(not(dtf:isAllowableDateTimeFormat(string($date)))) then true() else xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M64"/>
   <xsl:template match="@*|node()" priority="-2" mode="M64">
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00018-->
<xsl:template match="text()" priority="-1" mode="M65"/>
   <xsl:template match="@*|node()" priority="-2" mode="M65">
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00019-->


	<!--RULE -->
<xsl:template match="*[@ddms:approvedOn]" priority="1000" mode="M66">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@ddms:approvedOn]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:approvedOn)))             then every $secondaryDate in (@ddms:created,                                                 @ddms:posted) satisfies               if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))                 then dtf:compareDateTimeRanges(string(@ddms:approvedOn), '&lt;=', string($secondaryDate))                 else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:approvedOn))) then every $secondaryDate in (@ddms:created, @ddms:posted) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:approvedOn), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00019][Warning] @ddms:approvedOn must not be later than @ddms:created and @ddms:posted.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:approvedOn)))             then every $secondaryDate in (@ddms:created,                                                 @ddms:posted) satisfies              if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))              then dtf:compareDateTimeRanges(string(@ddms:approvedOn), '&lt;=', string($secondaryDate))              else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:approvedOn))) then every $secondaryDate in (@ddms:created, @ddms:posted) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:approvedOn), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00019][Warning] @ddms:approvedOn must not be later than @ddms:created and @ddms:posted.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M66"/>
   <xsl:template match="@*|node()" priority="-2" mode="M66">
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00020-->


	<!--RULE -->
<xsl:template match="*[@ddms:infoCutOff]" priority="1000" mode="M67">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@ddms:infoCutOff]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:infoCutOff)))             then every $secondaryDate in (@ddms:created,                                                 @ddms:posted) satisfies               if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))                 then dtf:compareDateTimeRanges(string(@ddms:infoCutOff), '&lt;=', string($secondaryDate))                 else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:infoCutOff))) then every $secondaryDate in (@ddms:created, @ddms:posted) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:infoCutOff), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00020][Error] @ddms:infoCutOff must not be later than @ddms:created, and @ddms:posted.          '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:infoCutOff)))             then every $secondaryDate in (@ddms:created,                                                 @ddms:posted) satisfies              if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))              then dtf:compareDateTimeRanges(string(@ddms:infoCutOff), '&lt;=', string($secondaryDate))              else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:infoCutOff))) then every $secondaryDate in (@ddms:created, @ddms:posted) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:infoCutOff), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00020][Error] @ddms:infoCutOff must not be later than @ddms:created, and @ddms:posted.          '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M67"/>
   <xsl:template match="@*|node()" priority="-2" mode="M67">
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00021-->


	<!--RULE -->
<xsl:template match="*[@ddms:validTil]" priority="1000" mode="M68">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@ddms:validTil]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:validTil)))             then every $secondaryDate in (@ddms:created,                                                  @ddms:posted,                                                  @ddms:infoCutOff,                                                 @ddms:approvedOn) satisfies               if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))                 then dtf:compareDateTimeRanges(string(@ddms:validTil), '&gt;=', string($secondaryDate))                 else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(@ddms:validTil))) then every $secondaryDate in (@ddms:created, @ddms:posted, @ddms:infoCutOff, @ddms:approvedOn) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:validTil), '&gt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00021][Warning] @ddms:validTil must not be earlier than         @ddms:created, @ddms:posted, @ddms:infoCutOff, and @ddms:approvedOn.          '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:validTil)))             then every $secondaryDate in (@ddms:created,                                                  @ddms:posted,                                                  @ddms:infoCutOff,                                                 @ddms:approvedOn) satisfies              if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))              then dtf:compareDateTimeRanges(string(@ddms:validTil), '&gt;=', string($secondaryDate))              else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(@ddms:validTil))) then every $secondaryDate in (@ddms:created, @ddms:posted, @ddms:infoCutOff, @ddms:approvedOn) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(@ddms:validTil), '&gt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00021][Warning] @ddms:validTil must not be earlier than         @ddms:created, @ddms:posted, @ddms:infoCutOff, and @ddms:approvedOn.          '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M68"/>
   <xsl:template match="@*|node()" priority="-2" mode="M68">
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00022-->


	<!--RULE -->
<xsl:template match="ddms:temporalCoverage" priority="1000" mode="M69">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:temporalCoverage"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(ddms:start)))             then every $secondaryDate in (ddms:end) satisfies               if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))                 then dtf:compareDateTimeRanges(string(ddms:start), '&lt;=', string($secondaryDate))                 else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'warning' and dtf:isAllowableDateTimeFormat(string(ddms:start))) then every $secondaryDate in (ddms:end) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(ddms:start), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00022][Error] For any element ddms:temporalCoverage, child element ddms:start must          not be later than child element ddms:end.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(ddms:start)))             then every $secondaryDate in (ddms:end) satisfies              if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))              then dtf:compareDateTimeRanges(string(ddms:start), '&lt;=', string($secondaryDate))              else true()             else true()             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if ('error' = 'error' and dtf:isAllowableDateTimeFormat(string(ddms:start))) then every $secondaryDate in (ddms:end) satisfies if(dtf:isAllowableDateTimeFormat(string($secondaryDate))) then dtf:compareDateTimeRanges(string(ddms:start), '&lt;=', string($secondaryDate)) else true() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00022][Error] For any element ddms:temporalCoverage, child element ddms:start must          not be later than child element ddms:end.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M69"/>
   <xsl:template match="@*|node()" priority="-2" mode="M69">
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00023-->


	<!--RULE -->
<xsl:template match="ddms:start | ddms:end" priority="1000" mode="M70">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:start | ddms:end"/>
      <xsl:variable name="minYear" select="0001"/>
      <xsl:variable name="maxYear" select="9999"/>
      <xsl:variable name="dateList" select="(string(ddms:start), string(ddms:end))"/>
      <xsl:variable name="errMsg"
                    select="'          [IRM-ID-00023][Error] The permissible values for the year range are 0001 through 9999           for elements ddms:start and ddms:end.          Human Readable: ddms:start and ddms:end must be positive integers less than 10,000.             '"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="        every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies         if(not(dtf:isAllowableDateTimeFormat(string($date))))         then true()         else          xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear          and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in tokenize(normalize-space(string-join($dateList, ' ')),' ') satisfies if(not(dtf:isAllowableDateTimeFormat(string($date)))) then true() else xs:integer(substring(string($date), 1, 4)) &lt;= $maxYear and xs:integer(substring(string($date), 1, 4)) &gt;= $minYear">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="$errMsg"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M70"/>
   <xsl:template match="@*|node()" priority="-2" mode="M70">
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00024-->


	<!--RULE -->
<xsl:template match="ddms:start" priority="1002" mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:start"/>
      <xsl:variable name="dateList" select="."/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             every $date in $dateList satisfies                 if($date castable as xs:dateTime and contains(string($date),'T'))                 then matches(string($date),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in $dateList satisfies if($date castable as xs:dateTime and contains(string($date),'T')) then matches(string($date),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00024][Warning] For elements and attributes of date-time types, if the 
            time designator (T) is specified, it is recommended that time zone be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="ddms:end" priority="1001" mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:end"/>
      <xsl:variable name="dateList" select="."/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             every $date in $dateList satisfies                 if($date castable as xs:dateTime and contains(string($date),'T'))                 then matches(string($date),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in $dateList satisfies if($date castable as xs:dateTime and contains(string($date),'T')) then matches(string($date),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00024][Warning] For elements and attributes of date-time types, if the 
            time designator (T) is specified, it is recommended that time zone be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@ddms:approvedOn |                          @ddms:dateProcessed |                         @ddms:receivedOn |                         @ddms:posted |                          @ddms:created |                          @ddms:infoCutOff |                          @ddms:validTil]"
                 priority="1000"
                 mode="M71">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@ddms:approvedOn |                          @ddms:dateProcessed |                         @ddms:receivedOn |                         @ddms:posted |                          @ddms:created |                          @ddms:infoCutOff |                          @ddms:validTil]"/>
      <xsl:variable name="dateList"
                    select="             (@ddms:approvedOn,              @ddms:dateProcessed,             @ddms:receivedOn,             @ddms:posted,             @ddms:created,             @ddms:infoCutOff,             @ddms:validTil)             "/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             every $date in $dateList satisfies                 if($date castable as xs:dateTime and contains(string($date),'T'))                 then matches(string($date),$endsWithTimeZoneRegEx)                 else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $date in $dateList satisfies if($date castable as xs:dateTime and contains(string($date),'T')) then matches(string($date),$endsWithTimeZoneRegEx) else true()">
               <xsl:attribute name="flag">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00024][Warning] For elements and attributes of date-time types, if the 
            time designator (T) is specified, it is recommended that time zone be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M71"/>
   <xsl:template match="@*|node()" priority="-2" mode="M71">
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00011-->
<xsl:template match="text()" priority="-1" mode="M72"/>
   <xsl:template match="@*|node()" priority="-2" mode="M72">
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00012-->


	<!--RULE -->
<xsl:template match="ddms:metacardInfo" priority="1000" mode="M73">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:metacardInfo"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(                     for $qualifier in ddms:identifier/@ddms:qualifier return                             if(normalize-space(string($qualifier)) = 'IC-ID')                             then 1                             else null                     ) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count( for $qualifier in ddms:identifier/@ddms:qualifier return if(normalize-space(string($qualifier)) = 'IC-ID') then 1 else null ) = 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00012][Error] There must exist exactly one element
            ddms:metacardInfo/ddms:identifier which specifies attribute
            @ddms:qualifier with a value of [IC-ID].
            
            Human Readable: The DDMS card must have a single IC-ID for itself.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M73"/>
   <xsl:template match="@*|node()" priority="-2" mode="M73">
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00013-->
<xsl:template match="text()" priority="-1" mode="M74"/>
   <xsl:template match="@*|node()" priority="-2" mode="M74">
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00014-->


	<!--RULE -->
<xsl:template match="ddms:resource" priority="1000" mode="M75">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:resource"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(            for $qualifier in ddms:identifier/@ddms:qualifier return                    if (normalize-space(string($qualifier)) = 'IC-ID')                    then 1                             else null                     ) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count( for $qualifier in ddms:identifier/@ddms:qualifier return if (normalize-space(string($qualifier)) = 'IC-ID') then 1 else null ) = 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00014][Error] There must exist exactly one element
            ddms:resource/ddms:identifier which specifies attribute @ddms:qualifier
            with a value of [IC-ID].
            
            Human Readable: The DDMS card must have exactly one IC-ID for
            the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M75"/>
   <xsl:template match="@*|node()" priority="-2" mode="M75">
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00029-->


	<!--RULE -->
<xsl:template match="ddms:geospatialCoverage[@ddms:precedence='Secondary']" priority="1000"
                 mode="M76">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:geospatialCoverage[@ddms:precedence='Secondary']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="../ddms:geospatialCoverage[@ddms:precedence='Primary']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="../ddms:geospatialCoverage[@ddms:precedence='Primary']">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00029][Error]
            If element ddms:geospatialCoverage has attribute @ddms:precedence with a value of [Secondary],
            there must be at least one sibling element ddms:geospatialCoverage for which attribute 
            @ddms:precedence has a value of [Primary].
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M76"/>
   <xsl:template match="@*|node()" priority="-2" mode="M76">
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00030-->


	<!--RULE -->
<xsl:template match="ddms:resource[//@ddms:order]" priority="1000" mode="M77">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[//@ddms:order]"/>
      <xsl:variable name="orderList"
                    select="tokenize(string-join(//@ddms:order/normalize-space(), ' '), ' ')"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="(count(distinct-values($orderList)) = count($orderList)                     and (every $index in 1 to count($orderList)                              satisfies index-of($orderList, xs:string($index))))             "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(count(distinct-values($orderList)) = count($orderList) and (every $index in 1 to count($orderList) satisfies index-of($orderList, xs:string($index))))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00030][Error]
            If attribute @ddms:order is specified with integer value N, there must exist 
            other @ddms:order attributes with values 1 to N-1 with no duplicates.
            
            Human Readable: The values of attribute @ddms:order must be numbered 
            sequentially with no duplicates, beginning at 1.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M77"/>
   <xsl:template match="@*|node()" priority="-2" mode="M77">
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00032-->
<xsl:template match="text()" priority="-1" mode="M78"/>
   <xsl:template match="@*|node()" priority="-2" mode="M78">
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00035-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M79">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:language"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ddms:language">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IRM-ID-00035][Error] If MIN_DISCOVERABLE_OR_GREATER, element ddms:resource
			must specify at least one element ddms:language.
			
			Human Readable: If this IRM instance complies with the minimum
			discoverability rules, then the DDMS card must specify the language of
			the referenced resource.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M79"/>
   <xsl:template match="@*|node()" priority="-2" mode="M79">
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00037-->


	<!--RULE -->
<xsl:template match="ddms:creator[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:publisher[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:contributor[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:pointOfContact[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))]"
                 priority="1000"
                 mode="M80">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:creator[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:publisher[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:contributor[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |                       ddms:pointOfContact[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="normalize-space(string(descendant::ddms:phone[1]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(descendant::ddms:phone[1]))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00037][Error]
            For elements ddms:creator, ddms:publisher, ddms:contributor, 
            and ddms:pointOfContact, if the attribute ism:pocType is specified with
            a value of [ORCON], then the element ddms:phone must be specified with a
            non-whitespace value.
            
            Human Readable: Elements ddms:creator, ddms:publisher, ddms:contributor, 
            and ddms:pointOfContact must specify a phone number if they are 
            denoted as the POC for an ORIGINATOR CONTROLLED data.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M80"/>
   <xsl:template match="@*|node()" priority="-2" mode="M80">
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00038-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M81">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:publisher"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ddms:publisher">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IRM-ID-00038][Error] If MIN_DISCOVERABLE_OR_GREATER, element ddms:resource
			must specify at least one element ddms:publisher.
			
			Human Readable: If this IRM instance complies with the minimum
			discoverability rules, then the DDMS card must specify the publisher of
			the referenced resource.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M81"/>
   <xsl:template match="@*|node()" priority="-2" mode="M81">
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00039-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M82">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="//ddms:subjectCoverage/ddms:productionMetric"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="//ddms:subjectCoverage/ddms:productionMetric">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IRM-ID-00039][Error] If MIN_DISCOVERABLE_OR_GREATER, element
			ddms:subjectCoverage must specify at least one element ddms:productionMetric.
			
			Human Readable: If this IRM instance complies with the minimum
			discoverability rules, then the DDMS card must specify a production metric
			of the referenced resource.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M82"/>
   <xsl:template match="@*|node()" priority="-2" mode="M82">
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00055-->


	<!--RULE -->
<xsl:template match="ddms:geospatialCoverage[@ddms:order]" priority="1000" mode="M83">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:geospatialCoverage[@ddms:order]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(ddms:geographicIdentifier/ddms:countryCode) + count(ddms:geographicIdentifier/ddms:subDivisionCode) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ddms:geographicIdentifier/ddms:countryCode) + count(ddms:geographicIdentifier/ddms:subDivisionCode) = 1">
               <xsl:attribute name="id">IRM-00055</xsl:attribute>
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IRM-ID-00055][Error] If ddms:geospatialCoverage/@order is specified then
			there must be one and only one of ddms:geospatialIdentifier/ddms:countryCode or
			ddms:geospatialIdentifier/ddms:subDivisionCode. Human Readable: A single order value
			must be applied to one country code or one subdivision code 
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M83"/>
   <xsl:template match="@*|node()" priority="-2" mode="M83">
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00056-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M84">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:title"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ddms:title">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00056][Error] If MIN_DISCOVERABLE_OR_GREATER, element
            ddms:resource must specify at least one element ddms:title.
            
            Human Readable: If this IRM instance complies with the minimum
            discoverability rules, then the DDMS card must specify the title
            of the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M84"/>
   <xsl:template match="@*|node()" priority="-2" mode="M84">
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00057-->
<xsl:template match="text()" priority="-1" mode="M85"/>
   <xsl:template match="@*|node()" priority="-2" mode="M85">
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00058-->
<xsl:template match="text()" priority="-1" mode="M86"/>
   <xsl:template match="@*|node()" priority="-2" mode="M86">
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00059-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M87">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:subjectCoverage"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ddms:subjectCoverage">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00059][Error] If MIN_DISCOVERABLE_OR_GREATER, element
            ddms:resource must specify at least one element ddms:subjectCoverage.
            
            Human Readable: If this IRM instance complies with the minimum
            discoverability rules, then the DDMS card must specify a subjectCoverage
            of the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M87"/>
   <xsl:template match="@*|node()" priority="-2" mode="M87">
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00060-->
<xsl:template match="text()" priority="-1" mode="M88"/>
   <xsl:template match="@*|node()" priority="-2" mode="M88">
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00061-->


	<!--RULE -->
<xsl:template match="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]" priority="1000" mode="M89">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource[$MIN_DISCOVERABLE_OR_GREATER]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:publisher or ddms:creator or ddms:contributor or ddms:pointOfContact"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ddms:publisher or ddms:creator or ddms:contributor or ddms:pointOfContact">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00061][Error] If MIN_DISCOVERABLE_OR_GREATER, element
            ddms:resource must specify at least one of the following elements:
            ddms:creator, ddms:publisher, ddms:contributor, or ddms:pointOfContact.
            
            Human Readable: If this IRM instance complies with the minimum
            discoverability rules, then the DDMS card must specify a creator,
            publisher, contributor, or pointOfContact for the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M89"/>
   <xsl:template match="@*|node()" priority="-2" mode="M89">
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00062-->


	<!--RULE -->
<xsl:template match="ddms:identifier[@ddms:qualifier='IC-ID']" priority="1000" mode="M90">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:identifier[@ddms:qualifier='IC-ID']"/>
      <xsl:variable name="icidRegEx"
                    select="'[Gg][Uu][Ii][Dd][Ee]://[0-9]{4}/[A-Za-z0-9_\-\.]{1,43}'"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="matches(string(@ddms:value),$icidRegEx)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="matches(string(@ddms:value),$icidRegEx)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00062][Error] The value of an IC-ID identifier must follow 
            standardized convention.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M90"/>
   <xsl:template match="@*|node()" priority="-2" mode="M90">
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00063-->


	<!--RULE -->
<xsl:template match="ddms:resource" priority="1000" mode="M91">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:resource"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:creator/ddms:organization/@ddms:acronym"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ddms:creator/ddms:organization/@ddms:acronym">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00063][Error] Element
            ddms:resource/ddms:creator/ddms:organization must specify attribute
            @ddms:acronym.
            
            Human Readable: The DDMS card must specify the creator organization of
            the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M91"/>
   <xsl:template match="@*|node()" priority="-2" mode="M91">
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00064-->


	<!--RULE -->
<xsl:template match="ddms:resource" priority="1000" mode="M92">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:resource"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="ddms:dates/@ddms:created"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ddms:dates/@ddms:created">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00064][Error] Element ddms:resource/ddms:dates must specify
            attribute @ddms:created.
            
            Human Readable: The DDMS card must specify the date on which the
            referenced resource was created.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M92"/>
   <xsl:template match="@*|node()" priority="-2" mode="M92">
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00065-->


	<!--RULE -->
<xsl:template match="ddms:resource/ddms:dates[@ddms:created]" priority="1000" mode="M93">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:resource/ddms:dates[@ddms:created]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ddms:created castable as xs:dateTime"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@ddms:created castable as xs:dateTime">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00065][Error] Attribute ddms:resource/ddms:dates/@ddms:created
            must be castable as an xs:dateTime type.
            
            Human Readable: The date on which the referenced resource was created
            must be a dateTime type.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M93"/>
   <xsl:template match="@*|node()" priority="-2" mode="M93">
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00066-->


	<!--RULE -->
<xsl:template match="ddms:security/ddms:noticeList/ism:Notice" priority="1000" mode="M94">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:security/ddms:noticeList/ism:Notice"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:externalNotice = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:externalNotice = true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00066][Error] For element ddms:security/ddms:noticeList, element ism:Notice
            must specify attribute ism:externalNotice with a value of [true].
            
            Human Readable: Notices within a ddms:security element always refer
            to the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M94"/>
   <xsl:template match="@*|node()" priority="-2" mode="M94">
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00067-->


	<!--RULE -->
<xsl:template match="ddms:security/ntk:Access" priority="1000" mode="M95">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:security/ntk:Access"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ntk:externalReference = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@ntk:externalReference = true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00067][Error] For element ddms:security, element ntk:Access
            must specify attribute ntk:externalReference with a value of [true].
            
            Human Readable: NTK information within a ddms:security element always
            refers to the referenced resource.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M95"/>
   <xsl:template match="@*|node()" priority="-2" mode="M95">
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00068-->


	<!--RULE -->
<xsl:template match="ddms:taskID[@xlink:href]" priority="1000" mode="M96">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:taskID[@xlink:href]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="normalize-space(string(@xlink:href))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(@xlink:href))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00068][Error]
            For element ddms:taskID if attribute xlink:href exists, then the attribute must have 
            a non-null value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M96"/>
   <xsl:template match="@*|node()" priority="-2" mode="M96">
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00069-->


	<!--RULE -->
<xsl:template match="ddms:taskID" priority="1000" mode="M97">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:taskID"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             if(not(@network) and @otherNetwork)             then false()             else true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if(not(@network) and @otherNetwork) then false() else true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00069][Error]
            If attribute network is not specified for element ddms:taskID, which allows the 
            attribute, then attribute otherNetwork must not be specified for the same element.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M97"/>
   <xsl:template match="@*|node()" priority="-2" mode="M97">
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00002-->


	<!--RULE -->
<xsl:template match="*[@*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')]]"
                 priority="1000"
                 mode="M98">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')]]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             every $attribute in @*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')] satisfies                 normalize-space(string($attribute))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attribute in @*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')] satisfies normalize-space(string($attribute))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00002][Error] For every attribute in the namespace
            [urn:us:gov:ic:irm] or [urn:us:mil:ces:metadata:ddms:4], a non-whitespace
            value must be specified.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M98"/>
   <xsl:template match="@*|node()" priority="-2" mode="M98">
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00025-->


	<!--RULE -->
<xsl:template match="*[@ism:excludeFromRollup and namespace-uri()='urn:us:mil:ces:metadata:ddms:4']"
                 priority="1000"
                 mode="M99">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[@ism:excludeFromRollup and namespace-uri()='urn:us:mil:ces:metadata:ddms:4']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="local-name() = 'security'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name() = 'security'">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00025][Error] The attribute @ism:excludeFromRollup must not be specified for any element 
            in the namespace [urn:us:mil:ces:metadata:ddms:4] except security.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M99"/>
   <xsl:template match="@*|node()" priority="-2" mode="M99">
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00026-->
<xsl:template match="text()" priority="-1" mode="M100"/>
   <xsl:template match="@*|node()" priority="-2" mode="M100">
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00040-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:activity']"
                 priority="1000"
                 mode="M101">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:activity']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00040][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:activity], then         attribute ism:classification must also be specified.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M101"/>
   <xsl:template match="@*|node()" priority="-2" mode="M101">
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00041-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:irm:intel:disciplines']"
                 priority="1000"
                 mode="M102">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:irm:intel:disciplines']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00041][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:irm:intel:disciplines], then         attribute ism:classification must also be specified.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M102"/>
   <xsl:template match="@*|node()" priority="-2" mode="M102">
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00042-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplines']"
                 priority="1000"
                 mode="M103">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplines']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00042][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:intel:subdisciplines], then         attribute ism:classification must also be specified.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M103"/>
   <xsl:template match="@*|node()" priority="-2" mode="M103">
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00043-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechnique']"
                 priority="1000"
                 mode="M104">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechnique']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00043][Error]         If element ddms:type is specified with a qualifier of          [urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechnique], then         attribute ism:classification must also be specified.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M104"/>
   <xsl:template match="@*|node()" priority="-2" mode="M104">
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00044-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:irm:productline']"
                 priority="1000"
                 mode="M105">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:irm:productline']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00044][Error]         If element ddms:type is specified with a qualifier of         [urn:us:gov:ic:irm:productline] then attribute ism:classification must         also be specified.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M105"/>
   <xsl:template match="@*|node()" priority="-2" mode="M105">
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00045-->


	<!--RULE -->
<xsl:template match="ddms:geospatialCoverage" priority="1000" mode="M106">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:geospatialCoverage"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@ism:classification"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ism:classification">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00045][Error] Element ddms:geospatialCoverage must have ISM
            classification markings.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M106"/>
   <xsl:template match="@*|node()" priority="-2" mode="M106">
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00001-->


	<!--RULE -->
<xsl:template match="ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:fips:digraph']"
                 priority="1000"
                 mode="M107">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:fips:digraph']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $coverageFipsDigraphList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $coverageFipsDigraphList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00001][Error] If element ddms:countryCode has attribute @ddms:qualifier specified as   [urn:us:gov:ic:cvenum:irm:coverage:fips:digraph] then the value of attribute @ddms:value must   be in CVEnumIRMCoverageFIPSDigraph.xml.      Human Readable: FIPS CountryCodes must in the the FIPS CVE.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M107"/>
   <xsl:template match="@*|node()" priority="-2" mode="M107">
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00003-->


	<!--RULE -->
<xsl:template match="ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166:trigraph']"
                 priority="1000"
                 mode="M108">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:countryCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166:trigraph']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $coverageIso3166TrigraphList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $coverageIso3166TrigraphList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00003][Error] If element ddms:countryCode has attribute @ddms:qualifier specified as   [urn:us:gov:ic:cvenum:irm:coverage:iso3166:trigraph] then the value of attribute @ddms:value must   be in CVEnumIRMCoverageISO3166trigraph.xml.      Human Readable: ISO trigraph CountryCodes must in the the ISO trigraph CVE.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M108"/>
   <xsl:template match="@*|node()" priority="-2" mode="M108">
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00004-->
<xsl:template match="text()" priority="-1" mode="M109"/>
   <xsl:template match="@*|node()" priority="-2" mode="M109">
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00005-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639:digraph']"
                 priority="1000"
                 mode="M110">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639:digraph']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $iso639DigraphList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $iso639DigraphList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00005][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639:digraph] then the value of attribute    @ddms:value must be in CVEnumIRMISO639Digraph.xml and no country code portion may    be specified in the ddms:language element value.      Human Readable: ISO 639 digraph language codes must be in the ISO 639 digraph CVE.    '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M110"/>
   <xsl:template match="@*|node()" priority="-2" mode="M110">
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00006-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-2:trigraph']"
                 priority="1000"
                 mode="M111">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-2:trigraph']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $iso639-2TrigraphList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $iso639-2TrigraphList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00006][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639-2:trigraph] then the value of    attribute @ddms:value must be in CVEnumIRMISO639-2Trigraph.xml and no country    code portion may be specified in the ddms:value attribute value.      Human Readable: ISO 639-2 trigraph language codes must be in the ISO 639-2   trigraph CVE.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M111"/>
   <xsl:template match="@*|node()" priority="-2" mode="M111">
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00007-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-3:trigraph']"
                 priority="1000"
                 mode="M112">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:iso639-3:trigraph']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $iso639-3TrigraphList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $iso639-3TrigraphList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00007][Error] If element ddms:language has the attribute @ddms:qualifier    value of [urn:us:gov:ic:cvenum:irm:iso639-3:trigraph] then the value of    attribute @ddms:value must be in CVEnumIRMISO639-3Trigraph.xml and no country code    portion may be specified in the ddms:value attribute value.      Human Readable: ISO 639-3 trigraph language codes must in the the ISO 639-3    trigraph CVE.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M112"/>
   <xsl:template match="@*|node()" priority="-2" mode="M112">
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00008-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='RFC1766']" priority="1000" mode="M113">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='RFC1766']"/>
      <xsl:variable name="tokens" select="tokenize(@ddms:value,'-')"/>
      <xsl:variable name="primarySubtag" select="$tokens[1]"/>
      <xsl:variable name="secondarySubtag" select="$tokens[2]"/>
      <xsl:variable name="badPrimaryValues"
                    select="             if(index-of($iso639DigraphList,$primarySubtag)&gt;0)                 then null             else $primarySubtag"/>
      <xsl:variable name="badSecondaryValues"
                    select="             if($secondarySubtag and                 index-of($coverageIso3166DigraphList,$secondarySubtag)&gt;0)                  then null             else $secondarySubtag"/>
      <xsl:variable name="badValues"
                    select="string-join(($badPrimaryValues,              $badSecondaryValues), ' ')"/>
      <xsl:variable name="primarySubtagValid"
                    select="             count($badPrimaryValues) = 0             "/>
      <xsl:variable name="secondarySubtagValid"
                    select="             if(not($secondarySubtag)) then true() else                 count($badSecondaryValues) = 0             "/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$primarySubtagValid and $secondarySubtagValid"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$primarySubtagValid and $secondarySubtagValid">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00008][Error] If element ddms:language has the attribute @ddms:qualifier 
            value of [RFC1766] then the language code portion of the @ddms:value attribute 
            value must be in CVEnumIRMISO639Digraph.xml and the country code portion, if 
            present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
            
            Human Readable: RFC1766 language codes must comply with the RFC by using parts from ISO 639 Digraph
            and ISO 3166 Digraph. The following values were found but are not in the CVEs: 
            <xsl:text/>
                  <xsl:value-of select="for $each in tokenize($badValues, ' ') return concat('[',$each,'] ')"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M113"/>
   <xsl:template match="@*|node()" priority="-2" mode="M113">
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00009-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='RFC3066']" priority="1000" mode="M114">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='RFC3066']"/>
      <xsl:variable name="tokens" select="tokenize(@ddms:value,'-')"/>
      <xsl:variable name="primarySubtag" select="$tokens[1]"/>
      <xsl:variable name="secondarySubtag" select="$tokens[2]"/>
      <xsl:variable name="badPrimaryValues"
                    select="             if(index-of($iso639-2TrigraphList,$primarySubtag)&gt;0 or                index-of($iso639DigraphList,$primarySubtag)&gt;0)                    then null             else $primarySubtag"/>
      <xsl:variable name="badSecondaryValues"
                    select="             if($secondarySubtag and                 index-of($coverageIso3166DigraphList,$secondarySubtag)&gt;0)                  then null             else $secondarySubtag"/>
      <xsl:variable name="badValues"
                    select="string-join(($badPrimaryValues,              $badSecondaryValues), ' ')"/>
      <xsl:variable name="primarySubtagValid"
                    select="             count($badPrimaryValues) = 0             "/>
      <xsl:variable name="secondarySubtagValid"
                    select="             if(not($secondarySubtag)) then true() else                 count($badSecondaryValues) = 0             "/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$primarySubtagValid and $secondarySubtagValid"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$primarySubtagValid and $secondarySubtagValid">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00009][Error] If element ddms:language has the attribute @ddms:qualifier 
            value of [RFC3066] then the language code portion of the @ddms:value attribute 
            value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
            and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
            
            Human Readable: RFC3066 language codes must comply with the RFC by using parts from 
            ISO 639 Digraph or ISO 639-2 Trigraph and ISO 3166 Digraph. The following values were found but 
            are not in the CVEs: 
            <xsl:text/>
                  <xsl:value-of select="for $each in tokenize($badValues, ' ') return concat('[',$each,'] ')"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M114"/>
   <xsl:template match="@*|node()" priority="-2" mode="M114">
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00010-->


	<!--RULE -->
<xsl:template match="ddms:language[@ddms:qualifier='RFC4646']" priority="1000" mode="M115">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:language[@ddms:qualifier='RFC4646']"/>
      <xsl:variable name="tokens" select="tokenize(@ddms:value,'-')"/>
      <xsl:variable name="primarySubtag" select="$tokens[1]"/>
      <xsl:variable name="secondarySubtag" select="$tokens[2]"/>
      <xsl:variable name="badPrimaryValues"
                    select="             if(index-of($iso639-2TrigraphList,lower-case($primarySubtag))&gt;0 or                index-of($iso639DigraphList,$primarySubtag)&gt;0)                  then null             else $primarySubtag"/>
      <xsl:variable name="badSecondaryValues"
                    select="             if($secondarySubtag and                index-of($coverageIso3166DigraphList,$secondarySubtag)&gt;0)                 then null             else $secondarySubtag"/>
      <xsl:variable name="badValues"
                    select="string-join(($badPrimaryValues,              $badSecondaryValues), ' ')"/>
      <xsl:variable name="primarySubtagValid"
                    select="             count($badPrimaryValues) = 0             "/>
      <xsl:variable name="secondarySubtagValid"
                    select="             if(not($secondarySubtag)) then true() else                 count($badSecondaryValues) = 0             "/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="$primarySubtagValid and $secondarySubtagValid"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$primarySubtagValid and $secondarySubtagValid">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IRM-ID-00010][Error] If element ddms:language has the attribute @ddms:qualifier 
            value of [RFC4646] then the language code portion of the @ddms:value attribute 
            value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
            and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
            
            Human Readable: RFC4646 language codes must comply with the RFC by using parts 
            from ISO 639 Digraph or ISO 639-2 Trigraph and ISO 3166 Digraph. The following 
            values were found but are not in the CVEs: 
            <xsl:text/>
                  <xsl:value-of select="for $each in tokenize($badValues, ' ') return concat('[',$each,'] ')"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M115"/>
   <xsl:template match="@*|node()" priority="-2" mode="M115">
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00027-->
<xsl:template match="text()" priority="-1" mode="M116"/>
   <xsl:template match="@*|node()" priority="-2" mode="M116">
      <xsl:apply-templates select="*" mode="M116"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00028-->
<xsl:template match="text()" priority="-1" mode="M117"/>
   <xsl:template match="@*|node()" priority="-2" mode="M117">
      <xsl:apply-templates select="*" mode="M117"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00031-->


	<!--RULE -->
<xsl:template match="ddms:countryCode" priority="1000" mode="M118">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:countryCode"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $compoundCountryCodeQualifierTypeList satisfies              $token = @ddms:qualifier or               matches(@ddms:qualifier, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $compoundCountryCodeQualifierTypeList satisfies $token = @ddms:qualifier or matches(@ddms:qualifier, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00031][Error]   The element countryCode must have the attribute qualifier specified   with a value in CVEnumIRMCompoundCountryCodeQualifierType.xml.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M118"/>
   <xsl:template match="@*|node()" priority="-2" mode="M118">
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00033-->


	<!--RULE -->
<xsl:template match="ddms:mimeType" priority="1000" mode="M119">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:mimeType"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $mimeTypeList satisfies              $token = . or               matches(., concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $mimeTypeList satisfies $token = . or matches(., concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00033][Error] If element ddms:mimeType is specified, it must have a value from CVEnumIRMMimeType.xml.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M119"/>
   <xsl:template match="@*|node()" priority="-2" mode="M119">
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00034-->


	<!--RULE -->
<xsl:template match="ddms:language" priority="1000" mode="M120">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="ddms:language"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $compoundLanguageQualifierTypeList satisfies              $token = @ddms:qualifier or               matches(@ddms:qualifier, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $compoundLanguageQualifierTypeList satisfies $token = @ddms:qualifier or matches(@ddms:qualifier, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'   [IRM-ID-00034][Error] For element ddms:language, attribute ddms:qualifier must have a    value in CVEnumIRMCompoundLanguageQualifierType.xml.   '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M120"/>
   <xsl:template match="@*|node()" priority="-2" mode="M120">
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00046-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechniques']"
                 priority="1000"
                 mode="M121">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechniques']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $subDisciplineTechniquesList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $subDisciplineTechniquesList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00046][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:subdisciplinetechniques]         the attribute @ddms:type must be in CVEnumIRMIntelSubDisciplineTechniques.xml.                  Human Readable: Intel Sub Discipline Techniques must be in the          CVEnumIRMIntelSubDisciplineTechniques CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M121"/>
   <xsl:template match="@*|node()" priority="-2" mode="M121">
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00047-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplines']"
                 priority="1000"
                 mode="M122">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:subdisciplines']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $intelSubDisciplinesList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $intelSubDisciplinesList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00047][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:subdisciplines]         the attribute @ddms:value must be in CVEnumIRMIntelSubDisciplines.xml.                  Human Readable: Intel Sub Disciplines must be in the          CVEnumIRMIntelSubDisciplines CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M122"/>
   <xsl:template match="@*|node()" priority="-2" mode="M122">
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00048-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:disciplines']"
                 priority="1000"
                 mode="M123">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:intel:disciplines']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $intelDisciplinesList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $intelDisciplinesList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00048][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:intel:disciplines]         the attribute @ddms:value must be in CVEnumIRMIntelDisciplines.xml.                  Human Readable: Intel Disciplines must be in the          CVEnumIRMIntelDisciplines CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M123"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M123"/>
   <xsl:template match="@*|node()" priority="-2" mode="M123">
      <xsl:apply-templates select="*" mode="M123"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00049-->


	<!--RULE -->
<xsl:template match="ddms:subDivisionCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166-2:subcountry']"
                 priority="1000"
                 mode="M124">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:subDivisionCode[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:coverage:iso3166-2:subcountry']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $coverageIso3166-2SubCountryList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $coverageIso3166-2SubCountryList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00049][Error]         If element ddms:subDivisionCode has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:coverage:iso3166-2:subcountry]         the attribute @ddms:value must be in CVEnumIRMCoverageISO3166-2SubCountry.xml.                  Human Readable: ISO 3166-2 Sub Country codes must be in the           CVEnumIRMCoverageISO3166-2SubCountry CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M124"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M124"/>
   <xsl:template match="@*|node()" priority="-2" mode="M124">
      <xsl:apply-templates select="*" mode="M124"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00050-->


	<!--RULE -->
<xsl:template match="ddms:productionMetric[@ddms:subject]" priority="1000" mode="M125">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:productionMetric[@ddms:subject]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $productionMetricsSubjectList satisfies              $token = @ddms:subject or               matches(@ddms:subject, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $productionMetricsSubjectList satisfies $token = @ddms:subject or matches(@ddms:subject, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00050][Error]         For element ddms:productionsMetrics, attribute @ddms:subject must          be in CVEnumIRMProductionMetricsSubject.xml.                  Human Readable: Production Metric Subjects must be in the           CVEnumIRMProductionMetricsSubject CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M125"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M125"/>
   <xsl:template match="@*|node()" priority="-2" mode="M125">
      <xsl:apply-templates select="*" mode="M125"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00051-->


	<!--RULE -->
<xsl:template match="ddms:productionMetric[@ddms:coverage]" priority="1000" mode="M126">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:productionMetric[@ddms:coverage]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $productionMetricsCoverageList satisfies              $token = @ddms:coverage or               matches(@ddms:coverage, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $productionMetricsCoverageList satisfies $token = @ddms:coverage or matches(@ddms:coverage, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00051][Error]         For element ddms:productionsMetrics, attribute @ddms:coverage must          be in CVEnumIRMProductionMetricsCoverage.xml.                  Human Readable: Production Metric Coverage values must be in the           CVEnumIRMProductionMetricsCoverage CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M126"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M126"/>
   <xsl:template match="@*|node()" priority="-2" mode="M126">
      <xsl:apply-templates select="*" mode="M126"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00052-->


	<!--RULE -->
<xsl:template match="ddms:organization[@ddms:acronym]" priority="1000" mode="M127">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:organization[@ddms:acronym]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $agencyAcronymList satisfies              $token = @ddms:acronym or               matches(@ddms:acronym, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $agencyAcronymList satisfies $token = @ddms:acronym or matches(@ddms:acronym, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00052][Error]         If element ddms:organization has attribute @ddms:acronym specified,         then the value must be in CVEnumIRMAgencyAcronym.xml.                  Human Readable: Agency acronyms must be in the CVEnumIRMAgencyAcronym CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M127"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M127"/>
   <xsl:template match="@*|node()" priority="-2" mode="M127">
      <xsl:apply-templates select="*" mode="M127"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00053-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:activity']"
                 priority="1000"
                 mode="M128">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:activity']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $activityList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $activityList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00053][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:activity]         the attribute @ddms:type must be in CVEnumIRMActivity.xml.                  Human Readable: Activity must be in the          CVEnumIRMActivity CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M128"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M128"/>
   <xsl:template match="@*|node()" priority="-2" mode="M128">
      <xsl:apply-templates select="*" mode="M128"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00054-->


	<!--RULE -->
<xsl:template match="ddms:geospatialCoverage[@ddms:precedence]" priority="1000" mode="M129">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:geospatialCoverage[@ddms:precedence]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $coveragePrecedenceList satisfies              $token = @ddms:precedence or               matches(@ddms:precedence, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $coveragePrecedenceList satisfies $token = @ddms:precedence or matches(@ddms:precedence, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00054][Error]         If element ddms:geospatialCoverage has attribute @ddms:precedence specified,         then the value must be in CVEnumIRMCoveragePrecedence.xml.                  Human Readable: ddms:geospatialCoverage/@ddms:precedence must be in the CVEnumIRMCoveragePrecedence CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M129"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M129"/>
   <xsl:template match="@*|node()" priority="-2" mode="M129">
      <xsl:apply-templates select="*" mode="M129"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00070-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:executableindicator']"
                 priority="1000"
                 mode="M130">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:executableindicator']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $executableIndicatorList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $executableIndicatorList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00070][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:executableindicator]         the attribute @ddms:type must be in CVEnumIRMExecutableIndicator.xml.                  HHuman Readable: Executable Indicator Value must be in the          CVEnumIRMExecutableIndicator CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M130"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M130"/>
   <xsl:template match="@*|node()" priority="-2" mode="M130">
      <xsl:apply-templates select="*" mode="M130"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00071-->


	<!--RULE -->
<xsl:template match="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:maliciouscodeindicator']"
                 priority="1000"
                 mode="M131">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="ddms:type[@ddms:qualifier='urn:us:gov:ic:cvenum:irm:maliciouscodeindicator']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="             some $token in $maliciousCodeIndicatorList satisfies              $token = @ddms:value or               matches(@ddms:value, concat('^',$token,'$'))                           "/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="some $token in $maliciousCodeIndicatorList satisfies $token = @ddms:value or matches(@ddms:value, concat('^',$token,'$'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
                  <xsl:text/>
                  <xsl:value-of select="'         [IRM-ID-00071][Error]         If element ddms:type has attribute @ddms:qualifier specified as         [urn:us:gov:ic:cvenum:irm:maliciouscodeindicator]         the attribute @ddms:type must be in CVEnumIRMMaliciousCodeIndicator.xml.                  Human Readable: Malicious Code Indicator values must be in the          CVEnumIRMMaliciousCodeIndicator CVE.         '"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M131"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M131"/>
   <xsl:template match="@*|node()" priority="-2" mode="M131">
      <xsl:apply-templates select="*" mode="M131"/>
   </xsl:template>

   <!--PATTERN IRM-ID-00036-->


	<!--RULE -->
<xsl:template match="*[@xlink:*]" priority="1000" mode="M132">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@xlink:*]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="normalize-space(string(@xlink:type))    or normalize-space(string(@xlink:href))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="normalize-space(string(@xlink:type)) or normalize-space(string(@xlink:href))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IRM-ID-00036][Error] For any element, if any attribute is specified with the 
			xlink namespace [http://www.w3.org/1999/xlink], then attributes @xlink:type and/or
			@xlink:href must be specified.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M132"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M132"/>
   <xsl:template match="@*|node()" priority="-2" mode="M132">
      <xsl:apply-templates select="*" mode="M132"/>
   </xsl:template>
</xsl:stylesheet>