<?xml version="1.0" encoding="UTF-8"?>
<?ICEA abstractPattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!-- Abstract rule, which asserts that the date contained
		 within $dateValue has a year value within the range
		 $minYear and $maxYear, inclusive. -->
<sch:rule xmlns:sch="http://purl.oclc.org/dsdl/schematron"
    abstract="true" 
    id="abs.dateYearRangeRule">
  <sch:assert test="
      if(not(dtf:yearPortionHasFourDigits(string($dateValue))))
      then false()
      else
          xs:integer(substring(string($dateValue), 1, 4)) &lt;= $maxYear and
          xs:integer(substring(string($dateValue), 1, 4)) &gt;= $minYear"
      flag="error">
      <sch:value-of select="$errMsg"/>
  </sch:assert>
</sch:rule>