<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00023" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00023][Error] The permissible values for the year range are 0001 through 9999 
        for elements ddms:start and ddms:end.
        
        Human Readable: ddms:start and ddms:end must be positive integers less than 10,000.
    </sch:p>
    
    <sch:p id="codeDesc">
        This pattern uses abstract rules to consolidate logic. For attributes, 
        we make sure that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </sch:p>
    
    <!-- Use abstract rule to handle required attributes -->
    <sch:rule context="ddms:start | ddms:end">
        <sch:let name="minYear" value="0001"/>
        <sch:let name="maxYear" value="9999"/>
        <sch:let name="dateList" value="(string(ddms:start), string(ddms:end))"/>
        <sch:let name="errMsg" value="'
        	[IRM-ID-00023][Error] The permissible values for the year range are 0001 through 9999 
        	for elements ddms:start and ddms:end.
        	Human Readable: ddms:start and ddms:end must be positive integers less than 10,000.
            '"/>
        <sch:extends rule="abs.dateListYearRangeRule"/>
    </sch:rule>
</sch:pattern>