<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<?ICEA min_accessible?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00012" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00012][Error] There must exist exactly one element
        ddms:metacardInfo/ddms:identifier which specifies attribute
        @ddms:qualifier with a value of [IC-ID].
        
        Human Readable: The DDMS card must have a single IC-ID for itself.
    </sch:p>
    <sch:p id="codeDesc"> 
        We make sure that exactly one element ddms:metacardInfo/ddms:identifier
        specifies attribute @ddms:qualifier with a value of [IC-ID].
    </sch:p>
    <sch:rule context="ddms:metacardInfo">
        <sch:assert
            test="count(
                    for $qualifier in ddms:identifier/@ddms:qualifier return
                            if(normalize-space(string($qualifier)) = 'IC-ID')
                            then 1
                            else null
                    ) = 1"
            flag="error">
            [IRM-ID-00012][Error] There must exist exactly one element
            ddms:metacardInfo/ddms:identifier which specifies attribute
            @ddms:qualifier with a value of [IC-ID].
            
            Human Readable: The DDMS card must have a single IC-ID for itself.
        </sch:assert>
    </sch:rule>
</sch:pattern>
