<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00002" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
      [IRM-ID-00002][Error] For every attribute in the namespace
      [urn:us:gov:ic:irm] or [urn:us:mil:ces:metadata:ddms:4], a non-whitespace
      value must be specified.
    </sch:p>
  
    <sch:p id="codeDesc">
        For each element which specifies an attribute in the IRM or DDMS
        namespace, we make sure that each attribute in the IRM or DDMS
        namespace specifies a non-whitespace value.
    </sch:p>

    <sch:rule context="*[@*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')]]">
        <sch:assert
            test="
            every $attribute in @*[namespace-uri()=('urn:us:gov:ic:irm', 'urn:us:mil:ces:metadata:ddms:4')] satisfies
                normalize-space(string($attribute))"
            flag="error">
            [IRM-ID-00002][Error] For every attribute in the namespace
            [urn:us:gov:ic:irm] or [urn:us:mil:ces:metadata:ddms:4], a non-whitespace
            value must be specified.
        </sch:assert>
    </sch:rule>
</sch:pattern>
