<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00009" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00009][Error] If element ddms:language has the attribute @ddms:qualifier 
        value of [RFC3066] then the language code portion of the @ddms:value attribute 
        value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
        
        Human Readable: RFC3066 language codes must comply with the RFC by using parts 
        from ISO 639 Digraph, 639-2 Trigraph, and ISO 3166 Digraph.
    </sch:p>
        
    <sch:p id="codeDesc">
        Finds ddms:language elements and checks its qualifier attribute for a value of
        [RFC3066]. If this value is found it will ensure that the value of the element's ddms:value 
        attribute exists in the CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
        enumeration files represented by the $iso639DigraphList or $iso639-2TrigraphList variables. 
        Country code portions (denoted by '-' separation) must be in the
        CVEnumIRMCoverageISO3166Digraph.xml enumeration file represented by the 
        $coverageIso3166DigraphList variable.
    </sch:p>
    
		<sch:rule context="ddms:language[@ddms:qualifier='RFC3066']">
        <!-- Tokenize the element Language value into a list -->
        <sch:let name="tokens" value="tokenize(@ddms:value,'-')"/>
        
        <!-- For convenience and readability, save the primary and secondary subtags 
             as defined in RFC 3066 -->
        <sch:let name="primarySubtag" value="$tokens[1]"/>
        <sch:let name="secondarySubtag" value="$tokens[2]"/>
        
        <sch:let name="badPrimaryValues" value="
            if(index-of($iso639-2TrigraphList,$primarySubtag)>0 or
               index-of($iso639DigraphList,$primarySubtag)>0)
                   then null
            else $primarySubtag"/>
        
        <sch:let name="badSecondaryValues" value="
            if($secondarySubtag and 
               index-of($coverageIso3166DigraphList,$secondarySubtag)>0)
                 then null
            else $secondarySubtag"/>
        
        <sch:let name="badValues" value="string-join(($badPrimaryValues, 
            $badSecondaryValues), ' ')"/>
        
        <!-- Check if primary subtag is valid -->
        <sch:let name="primarySubtagValid" value="
            count($badPrimaryValues) = 0
            "/>
        
        <!-- Check if secondary subtag is valid -->
        <sch:let name="secondarySubtagValid" value="
            if(not($secondarySubtag)) then true() else
                count($badSecondaryValues) = 0
            "/>
        
        <sch:assert 
            test="$primarySubtagValid and $secondarySubtagValid"
            flag="error">
            [IRM-ID-00009][Error] If element ddms:language has the attribute @ddms:qualifier 
            value of [RFC3066] then the language code portion of the @ddms:value attribute 
            value must be in CVEnumIRMISO639Digraph.xml or CVEnumIRMISO639-2Trigraph.xml 
            and the country code portion, if present, must be in CVEnumIRMCoverageISO3166Digraph.xml.
            
            Human Readable: RFC3066 language codes must comply with the RFC by using parts from 
            ISO 639 Digraph or ISO 639-2 Trigraph and ISO 3166 Digraph. The following values were found but 
            are not in the CVEs: 
            <sch:value-of select="for $each in tokenize($badValues, ' ') return concat('[',$each,'] ')"/>
        </sch:assert>
    </sch:rule>
</sch:pattern>