<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:tdf="urn:us:gov:ic:tdf"
                xmlns:ism="urn:us:gov:ic:ism"
                xmlns:arh="urn:us:gov:ic:arh"
                xmlns:edh="urn:us:gov:ic:edh"
                xmlns:ntk="urn:us:gov:ic:ntk"
                xmlns:util="urn:us:gov:ic:tdf:xsl:util"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->
<xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="util:containsAnyOfTheTokens"
                 as="xs:boolean">
        <xsl:param name="attribute"/>
        <xsl:param name="tokenList" as="xs:string+"/>
        <xsl:value-of select="some $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
    </xsl:function>
   <xsl:function xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                 name="util:containsOnlyTheTokens"
                 as="xs:boolean">
        <xsl:param name="attribute"/>
        <xsl:param name="tokenList" as="xs:string+"/>
        <xsl:value-of select="every $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
   </xsl:function>

   <!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="" schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:text> This is the root file for the IC-TDF Schematron rule set. It loads all of
        the required CVEs, declares some global variables, and includes all of the Rule .sch files. </svrl:text>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:tdf" prefix="tdf"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ism" prefix="ism"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:arh" prefix="arh"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:edh" prefix="edh"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:ntk" prefix="ntk"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:us:gov:ic:tdf:xsl:util" prefix="util"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00025</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00025</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00025][Error] Attribute @appliesToState is only allowed when 
    	TDO payload attrbute @isEncrypted equals "true".
    	
    	Human Readable: Handling Statement state applicability can only be defined
    	when an encrypted payload is present.		
    </svrl:text>
            <svrl:text>
		If attribute @appliesToState is defined, we ensure that there is a payload element 
		with attribute isEncrpyted set to true.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00026</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00026</xsl:attribute>
            <svrl:text>
		[IC-TDF-ID-00026][Error] If payload attribute @isEncrypted="true", then there needs to 
		be two handling assertions with attribute scope="PAYL": one with attribute 
		@appliesToState="encrypted" and the other with attribute appliesToState="unencrypted".
		
		Human Readable: Encrypted payloads require handling assertions for both encrypted and 
		unencrypted payload states. 
	</svrl:text>
            <svrl:text>
		If there exists a TDO payload element with attribute @isEncrypted as true, we ensure there
		is one handling assertion of @scope PAYL and @appliestostate of encrypted, and one handling 
		assertion of @scope PAYL and @appliestostate of unencrypted.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00027</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00027</xsl:attribute>
            <svrl:text>
		[IC-TDF-ID-00027][Error] If payload attribute @isEncrypted="true", the handling 
		assertion with @scope="PAYL" that contains @appliesToState=”unencrypted”  must 
		contain an edh:externalEDH.
		
		Human Readable: When content is encrypted, the handling assertion describing 
		the content in an unencrypted state is in effect external.
	</svrl:text>
            <svrl:text>
		If there exists a TDO payload element with attribute @isEncrypted as true, we ensure that there
		is one handling assertion of @scope PAYL, @appliestostate of unencrypted, and has descendant 
		element ExternalEdh.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00028</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00028</xsl:attribute>
            <svrl:text>
		[IC-TDF-ID-00028][Error] If payload attribute @isEncrypted="true" and the 
		payload is not external, the handling assertion with @scope="PAYL" that 
		contains @appliesToState="encrypted"  must contain a regular edh:EDH. 
		
		Human Readable: Internal content requires an EDH.
	</svrl:text>
            <svrl:text>
		
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00030</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00030</xsl:attribute>
            <svrl:text>
		[IC-TDF-ID-00030][Error] If statement attribute @isEncrypted="true", the statement metadata 
		 that contains @appliesToState=”unencrypted”  must 
		contain an edh:externalEDH 
		
		Human Readable: When statement content is encrypted, the handling statement describing the content in an unencrypted state is in effect external.
	</svrl:text>
            <svrl:text>
		
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00031</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00031</xsl:attribute>
            <svrl:text>
        [IC-TDF-ID-00031][Error] If assertion statement attribute @isEncrypted="true", then there needs to 
        be two statement metadata elements: one with attribute 
        @appliesToState="encrypted" and the other with attribute appliesToState="unencrypted". 
        
        Human Readable: If an assertion statement is encrypted, it must have statement metadata to describe handling for both it's encrypted state, and 
        unencrypted state.
    </svrl:text>
            <svrl:text>
        
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00032</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00032</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00032][Error] Attribute @appliesToState is only allowed when 
    	TDO statement attrbute @isEncrypted equals "true".
    	
    	Human Readable:  StatementMetadata state applicability can only be defined
    	when an encrypted statement is present.	  
    </svrl:text>
            <svrl:text>
		If attribute @appliesToState is defined, we ensure that there is a statement element 
		with attribute isEncrpyted set to true.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00001</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00001</xsl:attribute>
            <svrl:text>
        [IC-TDF-ID-00001][Error] All attributes in the TDF namespace MUST contain a non-whitespace value.
        
        Human Readable: All attributes in the TDF namespace must specify a value.
    </svrl:text>
            <svrl:text>
        For all attributes in the tdf namespace, we make sure that each contains a non-whitespace value.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00002</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00002</xsl:attribute>
            <svrl:text>
        [IC-TDF-ID-00002][Error] If the root element is TrustedDataObject, then it
        must specify attribute version.
        
        Human Readable: If TrustedDataObject is the root element, then it must declare a TDF version to which it complies.  
    </svrl:text>
            <svrl:text>
        For a tdf:TrustedDataObject element that is a root element, we make 
        sure that it specifies attribute tdf:version.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00003</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00003</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00003][Error] For element TrustedDataObject, there must be 
    	at least one element HandlingAssertion which specifies attribute scope
    	containing [PAYL].
    	
    	Human Readable: There must exist at least one handling marking for the payload.
    </svrl:text>
            <svrl:text>
        For each TrustedDataObject, we make sure that the count of HandlingAssertion
        element which specify attribute scope containing [PAYL] is greater than or equal to 1.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00004</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00004</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00004][Error] For element TrustedDataObject, there must be 
    	exactly one element HandlingAssertion which specifies attribute scope
    	containing [TDO].
    	
    	Human Readable: There must exist a single handling marking for the entire TrustedDataObject. 
    </svrl:text>
            <svrl:text>
        For element TrustedDataObject, we make sure that the count of HandlingAssertion
        elements which specify attribute scope containing [TDO] is exactly 1.
    </svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00005</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00005</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00005][Error] For element TrustedDataCollection, there must be
    	exactly one element HandlingAssertion which specifies attribute scope
    	containing [TDC]. 
    	
    	Human Readable: There must exist a single handling marking for the
    	entire TrustedDataCollection.
    </svrl:text>
            <svrl:text>
		For element TrustedDataCollection, we make sure that the count of 
		HandlingAssertion elements which specify attribute scope containing [TDC]
		is exactly 1.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00006</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00006</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00006][Error] For any child element of TrustedDataObject, the
    	only allowable tokens for attribute scope are [PAYL], [TDO], or [EXPLICIT]. 
    	
    	Human Readable: Scopes defined within a TrustedDataObject must refer to
    	the payload, the entire TrustedDataObject, the combination of the payload 
    	and the entire TrustedDataObject, or be explicitly defined.
    </svrl:text>
            <svrl:text>
		For the scope attribute specified on any child element of TrustedDataObject,
		we make sure that the value only contains the tokens [PAYL], [TDO], or [EXPLICIT].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00007</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00007</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00007][Error] For any child element of TrustedDataCollection, 
    	the only allowable tokens for attribute scope are [PAYL], [TDC], or [EXPLICIT].
    	
    	Human Readable: Scopes defined within a TrustedDataCollection must refer
    	to the payload (the list of TDOs), the entire TrustedDataCollection, or
    	be explicitly defined.
    </svrl:text>
            <svrl:text>
		For the scope attribute specified on any child element of TrustedDataCollection,
		we make sure that the value only contains the tokens [PAYL], [TDC], or [EXPLICIT].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00008</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00008</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00008][Error] The use of EXPLICIT scope is not currently allowed.
    	Key questions regarding the functionality of Binding within EXPLICIT scope
    	are still being defined. The rest of the rules/structure relating to
    	EXPLICIT scope are included in the spec to give the community an idea of
    	how these rules/structures will be defined.
    	
    	If you have a use-case which requires EXPLICIT scope, please send an 
    	email to datastandardssupport@ugov.gov so that we can incorporate the
    	use-case while defining the behavior of EXPLICIT scope.
    </svrl:text>
            <svrl:text>
		For any element which specifies attribute scope containing [EXPLICIT],
		we instantly fail because EXPLICIT scope is currently not supported.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00009</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00009</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00009][Error] For element Binding, if element BoundValueList 
    	is specified, then element SignatureValue must not specify attribute
    	includesStatementMetadata.
    	
    	Human Readable: If BoundValueList is present, then it will explicitly 
    	specify includesStatementMetadata for each BoundValue and therefore
    	attribute includesStatementMetadata on the SignatureValue is not applicable.
    </svrl:text>
            <svrl:text>
		For element Binding which specifies BoundValueList, we make sure that
		element SignatureValue does not specify attribute includesStatementMetadata.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M24"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00010</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00010</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00010][Error] For element Binding, if element BoundValueList is
    	not specified, then element SignatureValue must specify attribute
    	includesStatementMetadata.
    	
    	Human Readable: If BoundValueList is not present, then SignatureValue
    	must indicate whether or not to include the StatementMetadata of all
    	Assertions included in the binding.
    </svrl:text>
            <svrl:text>
		For element Binding that does not have child element BoundValueList, we
		make sure that child element SignatureValue specifies attribute
		includesStatementMetadata.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M25"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00011</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00011</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00011][Error] For all BoundValue or Reference elements within a TrustedDataObject, idRef attribute 
    	values must reference the id value of a descendant of the same TrustedDataObject that 
    	contains the Reference or BoundValue element.
    	
    	Human Readable: Assertions and HandlingAssertions within a
    	TrustedDataObject must reference elements local to that TrustedDataObject. 
    </svrl:text>
            <svrl:text>
		For element TrustedDataObject, we ensure each attribute @idRef value has 
		matching @id value in the same TDO.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M26"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00012</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00012</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00012][Error] For any element which specifies attribute scope 
    	containing [EXPLICIT], then element Binding/BoundValueList or 
    	element ReferenceList must be specified.
    	
    	Human Readable: For explicit scope, you must use a BoundValueList or 
    	a ReferenceList to explicitly reference elements are in scope. 
    </svrl:text>
            <svrl:text>
		For elements which specify attribute scope with a value of [EXPLICIT],
		we make sure that element Binding/BoundValueList or ReferenceList
		is specified.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M27"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00013</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00013</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00013][Error] Elements ReferenceList and BoundValueList are
    	currently not allowed. Key questions regarding the functionality of
    	granular references and granular binding are still being defined. The 
    	rest of the rules/structure relating to these elements are included in
    	the spec to give the community an idea of how these rules/structures 
    	will be defined.
    	
    	If you have a use-case which requires granular references or granular
    	binding, please send an email to datastandardssupport@ugov.gov so that
    	we can incorporate the use-case while defining the behavior and rules.
    </svrl:text>
            <svrl:text>
		Elements ReferenceList and BoundValueList are
		not allowed in v1.  This rule will in the future require that elements which specify element ReferenceList or Binding/BoundValueList
		have attribute scope is specified with a value of [EXPLICIT].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M28"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00014</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00014</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00014][Error] If EncryptionInformation is specified, then
    	the data it refers to must be label as encrypted. (Assertion Statement
    	or TrustedDataObject Payload).
    </svrl:text>
            <svrl:text>
		Make sure that the following sibling of EncryptionInformation, the
		Payload or Assertion Statement, has the encrypted attribute set to 
		true.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M29"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00015</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00015</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00015][Error] If data is label as encrypted, then
    	EncryptionInformation must be specified. (Assertion Statement
    	or TrustedDataObject Payload).
    </svrl:text>
            <svrl:text>
		Make sure that the previous sibling of the Statement or Payload marked
		with the encrypted attribute set to true is EncryptionInformation.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M30"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00016</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00016</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00016][Error] HandlingAssertions with scope containing
    	the token [TDO] must have an EDH whose ARH security element has
    	ism:resourceElement="true" specified.
    	
    	Human Readable: When a HandlingAssertion has scope pertaining to
    	the entire TrustedDataObject (TDO) it must declare itself a resource level
    	object.
    </svrl:text>
            <svrl:text>
		Where a HandlingAssertion exists with scope containing [TDO], ensure that its decendant ARH element,
		Security or ExternalSecurity, has ism:resourceElement specified with a value of true.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M31"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00017</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00017</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00017][Error] HandlingAssertions with scope containing
    	the token [TDC] must have an EDH whose ARH security element has
    	ism:resourceElement="true" specified.
    	
    	Human Readable: When a HandlingAssertion has scope pertaining to
    	the entire TrustedDataCollection (TDC) it must declare itself a resource level
    	object.
    </svrl:text>
            <svrl:text>
		Where a HandlingAssertion exists with scope containing [TDC], ensure that its decendant ARH element,
		Security or ExternalSecurity, has ism:resourceElement specified with a value of true.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M32"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00018</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00018</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00018][Error] HandlingAssertions with scope containing
    	the token [TDO] cannot use the ExternalEdh child element.
    	
    	Human Readable: When a HandlingAssertion has scope pertaining to
    	the entire TrustedDataObject (TDO), it must never use the
    	ExternalEdh child element because the HandlingAssertion will 
    	always refer to the object in which it resides.
    </svrl:text>
            <svrl:text>
		Where a HandlingAssertion exists with scope containing [TDO], ensure that it does
		not have a child of ExternalEdh.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M33"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00019</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00019</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00019][Error] HandlingAssertions with scope containing
    	the token [TDC] cannot use the ExternalEdh child element.
    	
    	Human Readable: When a HandlingAssertion has scope pertaining to
    	the entire TrustedDataCollection (TDC), it must never use the
    	ExternalEdh child element because the HandlingAssertion will always
    	refer to the Collection in which it resides.
    </svrl:text>
            <svrl:text>
		Where a HandlingAssertion exists with scope containing [TDC], ensure that it does
		not have a child of ExternalEdh.
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M34"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00020</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00020</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00020][Error] For element TrustedDataObject, if element
    	ReferenceValuePayload is specified, then there must exist two independent
    	HandlingAssertion elements, one with attribute scope specified with a value
    	of [TDO] and the other with attribute scope specified with a value of [PAYL].
    	
    	Human Readable: If a ReferenceValuePayload is used, then the instance
    	is not the minimal case and must specify markings for the payload
    	and the TDO instance separately.
    </svrl:text>
            <svrl:text>
		For every TrustedDataObject with a ReferenceValuePayload child element, 
		we ensure that there exists two independent	HandlingAssertion elements, 
		one of scope [TDO] and one of [PAYL].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M35"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00021</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00021</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00021][Error] For element TrustedDataObject, if any Assertion
    	elements are specified, then there must exist two independent 
    	HandlingAssertion elements, one with attribute scope specified with a 
    	value of [TDO] and the other with attribute scope specified with a 
    	value of [PAYL].
    	
    	Human Readable: If any Assertion elements are specified, then the instance
    	is not the minimal case and must specify markings for the payload
    	and the TDO instance separately.
    </svrl:text>
            <svrl:text>
		For every TrustedDataObject with an Assertion child element, we ensure 
		that there exists two independent HandlingAssertion elements, one of 
		scope [TDO] and one of [PAYL].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M36"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00022</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00022</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00022][Error] For element TrustedDataObject, if there is
    	a single HandlingAssertion element and it contains any ism:Notice 
    	elements which specify any ISM attributes other than ism:classification
    	with a value of [U] and ism:ownerProducer with a value of [USA], then
    	there must exist two independent HandlingAssertion elements, one with
    	attribute scope specified with a value of [TDO] and the other with 
    	attribute scope specified with a value of [PAYL].
    	
    	Human Readable: If the single IC-EDH contains classified information 
    	within a Notice, then the instance is not the minimal case and must
    	specify markings for the payload and the TDO instance separately.
    </svrl:text>
            <svrl:text>
		For TrustedDataObject elements with a single HandlingAssertion descendant 
		element and any ism:Notice elements which specify any ISM attributes other
		than ism:classification with a value of [U] and ism:ownerProducer with a 
		value of [USA], we ensure that there exists two independent
		HandlingAssertion elements, one of scope [TDO] and one of [PAYL].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M37"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00023</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00023</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00023][Error] For element TrustedDataObject, if there is
    	a single HandlingAssertion element and it contains any edh:ResponsibleEntity 
    	elements which specify any ISM attributes other than ism:classification
    	with a value of [U] and ism:ownerProducer with a value of [USA], then
    	there must exist two independent HandlingAssertion elements, one with
    	attribute scope specified with a value of [TDO] and the other with 
    	attribute scope specified with a value of [PAYL].
    	
    	Human Readable: If the single IC-EDH contains classified information 
    	within a ResponsibleEntity, then the instance is not the minimal case
    	and must specify markings for the payload and the TDO instance separately.
    </svrl:text>
            <svrl:text>
		For TrustedDataObject elements with a single HandlingAssertion descendant 
		element and any ism:Notice elements which specify any ISM attributes other
		than ism:classification with a value of [U] and ism:ownerProducer with a 
		value of [USA], we ensure that there exists two independent
		HandlingAssertion elements, one of scope [TDO] and one of [PAYL].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M38"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">IC-TDF-ID-00024</xsl:attribute>
            <xsl:attribute name="name">IC-TDF-ID-00024</xsl:attribute>
            <svrl:text>
    	[IC-TDF-ID-00024][Error] For element TrustedDataObject, if there is
    	a single HandlingAssertion element and it contains any ntk:Access or
    	ntk:ExternalAccess elements which specify any ISM attributes other than
    	ism:classification with a value of [U] and ism:ownerProducer with a 
    	value of [USA], then there must exist two independent HandlingAssertion
    	elements, one with attribute scope specified with a value of [TDO] and 
    	the other with attribute scope specified with a value of [PAYL].
    	
    	Human Readable: If the single IC-EDH contains classified information 
    	within NTK information, then the instance is not the minimal case
    	and must specify markings for the payload and the TDO instance separately.
    </svrl:text>
            <svrl:text>
		For TrustedDataObject elements with a single HandlingAssertion descendant 
		element and NTK elements which specify ISM attributes other than 
		ism:classification with a value of [U] and ism:ownerProducer with a value 
		of [USA], we ensure that there exists two independent HandlingAssertion 
		elements, one of scope [TDO] and one of [PAYL].
	</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M39"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN IC-TDF-ID-00025-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject[tdf:HandlingAssertion/@tdf:appliesToState]"
                 priority="1000"
                 mode="M9">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[tdf:HandlingAssertion/@tdf:appliesToState]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="./*/@tdf:isEncrypted = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./*/@tdf:isEncrypted = true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00024][Error] Attribute @appliesToState is only allowed when 
			TDO payload attrbute @isEncrypted equals "true".
			
			Human Readable: Handling Statement state applicability can only be defined
			when an encrypted payload is present.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00026-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/tdf:*[@tdf:isEncrypted=true()]" priority="1000"
                 mode="M10">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:*[@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='encrypted'])= 1    and     count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='unencrypted'])= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='encrypted'])= 1 and count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='unencrypted'])= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00026][Error] If payload attribute @isEncrypted="true", then there needs to 
			be two handling assertions with attribute scope="PAYL": one with attribute 
			@appliesToState="encrypted" and the other with attribute appliesToState="unencrypted".
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00027-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/tdf:*[@tdf:isEncrypted=true()]" priority="1000"
                 mode="M11">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:*[@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL'))    and @tdf:appliesToState='unencrypted']/tdf:HandlingStatement/edh:ExternalEdh)= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(parent::node()/tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='unencrypted']/tdf:HandlingStatement/edh:ExternalEdh)= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00027][Error] If payload attribute @isEncrypted="true", the handling 
			assertion with @scope="PAYL" that contains @appliesToState=”unencrypted”  must 
			contain an edh:externalEDH. 
			
			Human Readable: When content is encrypted, the handling assertion describing the content in an unencrypted state is in effect external.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00028-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject[tdf:StringPayload/@tdf:isEncrypted=true()] |    tdf:TrustedDataObject[tdf:Base64BinaryPayload/@tdf:isEncrypted=true()] |    tdf:TrustedDataObject[tdf:StructuredPayload/@tdf:isEncrypted=true()]"
                 priority="1000"
                 mode="M12">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[tdf:StringPayload/@tdf:isEncrypted=true()] |    tdf:TrustedDataObject[tdf:Base64BinaryPayload/@tdf:isEncrypted=true()] |    tdf:TrustedDataObject[tdf:StructuredPayload/@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL'))    and @tdf:appliesToState='encrypted']/tdf:HandlingStatement/edh:Edh)= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL')) and @tdf:appliesToState='encrypted']/tdf:HandlingStatement/edh:Edh)= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00028][Error] If payload attribute @isEncrypted="true" and the 
			payload is not external, the handling assertion with @scope="PAYL" that 
			contains @appliesToState="encrypted"  must contain a regular edh:EDH. 
			
			Human Readable: Internal content requires an EDH.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00030-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/tdf:Assertion/tdf:*[@tdf:isEncrypted=true()]"
                 priority="1000"
                 mode="M13">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:Assertion/tdf:*[@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='unencrypted']/edh:ExternalEdh)= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='unencrypted']/edh:ExternalEdh)= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
		
			
			[IC-TDF-ID-00030][Error] If statement attribute @isEncrypted="true", the statement metadata 
			that contains @appliesToState=”unencrypted”  must 
			contain an edh:externalEDH 
			
			Human Readable: When statement content is encrypted, the handling statement describing the content in an unencrypted state is in effect external.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00031-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/tdf:Assertion/tdf:*[@tdf:isEncrypted=true()]"
                 priority="1000"
                 mode="M14">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:Assertion/tdf:*[@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='encrypted'])= 1             and              count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='unencrypted'])= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='encrypted'])= 1 and count(parent::node()/tdf:StatementMetadata[@tdf:appliesToState='unencrypted'])= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IC-TDF-ID-00031][Error]  If assertion statement attribute @isEncrypted="true", then there needs to 
            be two statement metadata elements: one with attribute 
            @appliesToState="encrypted" and the other with attribute appliesToState="unencrypted". 
            
            Human Readable: If an assertion statement is encrypted, it must have statement metadata to describe handling for both for
            it's encrypted state, and unencrypted state.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00032-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/tdf:Assertion[tdf:StatementMetadata/@tdf:appliesToState]"
                 priority="1000"
                 mode="M15">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/tdf:Assertion[tdf:StatementMetadata/@tdf:appliesToState]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="./*/@tdf:isEncrypted = true()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./*/@tdf:isEncrypted = true()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00032][Error] Attribute @appliesToState is only allowed when 
			TDO statement attrbute @isEncrypted equals "true".
			
			Human Readable:  StatementMetadata state applicability can only be defined
			when an encrypted statement is present. 
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00001-->


	<!--RULE -->
<xsl:template match="*[@tdf:*]" priority="1000" mode="M16">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="*[@tdf:*]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="every $attribute in @tdf:* satisfies               normalize-space(string($attribute))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $attribute in @tdf:* satisfies normalize-space(string($attribute))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IC-TDF-ID-00001][Error] All attributes in the TDF namespace must specify a value.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00002-->


	<!--RULE -->
<xsl:template match="/tdf:TrustedDataObject" priority="1000" mode="M17">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="/tdf:TrustedDataObject"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@tdf:version"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@tdf:version">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
            [IC-TDF-ID-00002][Error] If TrustedDataObject is the root element, then it must declare a TDF version to which it complies. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00003-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject" priority="1000" mode="M18">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="tdf:TrustedDataObject"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL'))])&gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('PAYL'))])&gt;= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>			
        	[IC-TDF-ID-00003][Error] For element TrustedDataObject, there must be 
        	at least one element HandlingAssertion which specifies attribute scope
        	containing [PAYL].
        	
        	Human Readable: There must exist at least one handling marking for the payload.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00004-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject" priority="1000" mode="M19">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="tdf:TrustedDataObject"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))])= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))])= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>			
        	[IC-TDF-ID-00004][Error] For element TrustedDataObject, there must be 
        	exactly one element HandlingAssertion which specifies attribute scope
        	containing [TDO].
        	
        	Human Readable: There must exist a single handling marking for the entire TrustedDataObject.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00005-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataCollection" priority="1000" mode="M20">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="tdf:TrustedDataCollection"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))])= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(child::tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))])= 1">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>			
        	[IC-TDF-ID-00005][Error] For element TrustedDataCollection, there must be
        	exactly one element HandlingAssertion which specifies attribute scope
        	containing [TDC]. 
        	
        	Human Readable: There must exist a single handling marking for the
        	entire TrustedDataCollection.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00006-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject/*[@tdf:scope]" priority="1000" mode="M21">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject/*[@tdf:scope]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="util:containsOnlyTheTokens(@tdf:scope, ('PAYL', 'TDO', 'EXPLICIT'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="util:containsOnlyTheTokens(@tdf:scope, ('PAYL', 'TDO', 'EXPLICIT'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>			
			[IC-TDF-ID-00006][Error] For any child element of TrustedDataObject, the
			only allowable tokens for attribute scope are [PAYL], [TDO], or [EXPLICIT]. 
			
			Human Readable: Scopes defined within a TrustedDataObject must refer to
			the payload, the entire TrustedDataObject, the combination of the payload 
			and the entire TrustedDataObject, or be explicitly defined.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00007-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataCollection/*[@tdf:scope]" priority="1000" mode="M22">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataCollection/*[@tdf:scope]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="util:containsOnlyTheTokens(@tdf:scope, ('PAYL', 'TDC', 'EXPLICIT'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="util:containsOnlyTheTokens(@tdf:scope, ('PAYL', 'TDC', 'EXPLICIT'))">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00007][Error] For any child element of TrustedDataCollection, 
			the only allowable tokens for attribute scope are [PAYL], [TDC], or [EXPLICIT].
			
			Human Readable: Scopes defined within a TrustedDataCollection must refer
			to the payload (the list of TDOs), the TrustedDataCollection itself, or
			be explicitly defined.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00008-->


	<!--RULE -->
<xsl:template match="*[util:containsAnyOfTheTokens(@tdf:scope, ('EXPLICIT'))]"
                 priority="1000"
                 mode="M23">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[util:containsAnyOfTheTokens(@tdf:scope, ('EXPLICIT'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00008][Error] The use of EXPLICIT scope is not currently allowed.
			Key questions regarding the functionality of Binding within EXPLICIT scope
			are still being defined. The rest of the rules/structure relating to
			EXPLICIT scope are included in the spec to give the community an idea of
			how these rules/structures will be defined.
			
			If you have a use-case which requires EXPLICIT scope, please send an 
			email to datastandardssupport@ugov.gov so that we can incorporate the
			use-case while defining the behavior of EXPLICIT scope.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00009-->


	<!--RULE -->
<xsl:template match="tdf:Binding[tdf:BoundValueList]" priority="1000" mode="M24">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:Binding[tdf:BoundValueList]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:SignatureValue/@tdf:includesStatementMetadata)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:SignatureValue/@tdf:includesStatementMetadata)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[IC-TDF-ID-00009][Error] For element Binding, if element BoundValueList 
        	is specified, then element SignatureValue must not specify attribute
        	includesStatementMetadata.
        	
        	Human Readable: If BoundValueList is present, then it will explicitly 
        	specify includesStatementMetadata for each BoundValue and therefore
        	attribute includesStatementMetadata on the SignatureValue is not applicable.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00010-->


	<!--RULE -->
<xsl:template match="tdf:Binding[not(tdf:BoundValueList)]" priority="1000" mode="M25">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:Binding[not(tdf:BoundValueList)]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="tdf:SignatureValue/@tdf:includesStatementMetadata"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="tdf:SignatureValue/@tdf:includesStatementMetadata">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[IC-TDF-ID-00010][Error] For element Binding, if element BoundValueList is
        	not specified, then element SignatureValue must specify attribute
        	includesStatementMetadata.
        	
        	Human Readable: If BoundValueList is not present, then SignatureValue
        	must indicate whether or not to include the StatementMetadata of all
        	Assertions included in the binding.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00011-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject" priority="1000" mode="M26">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="tdf:TrustedDataObject"/>
      <xsl:variable name="ids" select=".//@tdf:id"/>
      <xsl:variable name="externalIdRefs"
                    select="       for $idRef in .//@tdf:idRef return        if($idRef = $ids)        then null        else $idRef"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count($externalIdRefs) = 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count($externalIdRefs) = 0">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[IC-TDF-ID-00011][Error] For all BoundValue or Reference elements within a TrustedDataObject, idRef attribute 
        	values must reference the id value of a descendant of the same TrustedDataObject that 
        	contains the Reference or BoundValue element.
        	
        	
        	Human Readable: Assertions and HandlingAssertions within a
        	TrustedDataObject must reference elements local to that TrustedDataObject.
        	
        	The following idRefs reference elements outside of this TrustedDataObject: (
        	<xsl:text/>
                  <xsl:value-of select="for $externalRef in $externalIdRefs return concat(string($externalRef), ', ')"/>
                  <xsl:text/>).
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00012-->


	<!--RULE -->
<xsl:template match="*[normalize-space(string(@tdf:scope)) = 'EXPLICIT']" priority="1000"
                 mode="M27">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="*[normalize-space(string(@tdf:scope)) = 'EXPLICIT']"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="tdf:Binding/tdf:BoundValueList or tdf:ReferenceList"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="tdf:Binding/tdf:BoundValueList or tdf:ReferenceList">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
        	[IC-TDF-ID-00012][Error] For any element which specifies attribute scope 
        	containing [EXPLICIT], then element Binding/BoundValueList or 
        	element ReferenceList must be specified.
        	
        	Human Readable: For explicit scope, you must use a BoundValueList or 
        	a ReferenceList to explicitly reference elements are in scope. 
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00013-->


	<!--RULE -->
<xsl:template match="tdf:ReferenceList | tdf:Binding/tdf:BoundValueList" priority="1000"
                 mode="M28">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:ReferenceList | tdf:Binding/tdf:BoundValueList"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00013][Error] Elements ReferenceList and BoundValueList are
			currently not allowed. Key questions regarding the functionality of
			granular references and granular binding are still being defined. The 
			rest of the rules/structure relating to these elements are included in
			the spec to give the community an idea of how these rules/structures 
			will be defined.
			
			If you have a use-case which requires granular references or granular
			binding, please send an email to datastandardssupport@ugov.gov so that
			we can incorporate the use-case while defining the behavior and rules.
        </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M28"/>
   <xsl:template match="@*|node()" priority="-2" mode="M28">
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00014-->


	<!--RULE -->
<xsl:template match="tdf:EncryptionInformation" priority="1000" mode="M29">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="tdf:EncryptionInformation"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="following-sibling::tdf:*[@tdf:isEncrypted=true()]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="following-sibling::tdf:*[@tdf:isEncrypted=true()]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00014][Error] If EncryptionInformation is specified, then
			the data it refers to must be label as encrypted. (Assertion Statement
			or TrustedDataObject Payload).
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M29"/>
   <xsl:template match="@*|node()" priority="-2" mode="M29">
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00015-->


	<!--RULE -->
<xsl:template match="tdf:*[@tdf:isEncrypted=true()]" priority="1000" mode="M30">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:*[@tdf:isEncrypted=true()]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="preceding-sibling::tdf:EncryptionInformation"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="preceding-sibling::tdf:EncryptionInformation">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00015][Error] If data is label as encrypted, then
			EncryptionInformation must be specified. (Assertion Statement
			or TrustedDataObject Payload).
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M30"/>
   <xsl:template match="@*|node()" priority="-2" mode="M30">
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00016-->


	<!--RULE -->
<xsl:template match="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))]"
                 priority="1000"
                 mode="M31">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="descendant::arh:*[@ism:resourceElement=true()]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant::arh:*[@ism:resourceElement=true()]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00016][Error] HandlingAssertions with scope containing
			the token [TDO] must have an EDH whose ARH security element has
			ism:resourceElement="true" specified.
			
			Human Readable: When a HandlingAssertion has scope pertaining to
			the entire TrustedDataObject (TDO) it must declare itself a resource level
			object.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M31"/>
   <xsl:template match="@*|node()" priority="-2" mode="M31">
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00017-->


	<!--RULE -->
<xsl:template match="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))]"
                 priority="1000"
                 mode="M32">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="descendant::arh:*[@ism:resourceElement=true()]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant::arh:*[@ism:resourceElement=true()]">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00017][Error] HandlingAssertions with scope containing
			the token [TDC] must have an EDH whose ARH security element has
			ism:resourceElement="true" specified.
			
			Human Readable: When a HandlingAssertion has scope pertaining to
			the entire TrustedDataCollection (TDC) it must declare itself a resource level
			object.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M32"/>
   <xsl:template match="@*|node()" priority="-2" mode="M32">
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00018-->


	<!--RULE -->
<xsl:template match="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))]"
                 priority="1000"
                 mode="M33">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDO'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(descendant::edh:ExternalEdh)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(descendant::edh:ExternalEdh)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00018][Error] HandlingAssertions with scope containing
			the token [TDO] cannot use the ExternalEdh child element.
			
			Human Readable: When a HandlingAssertion has scope pertaining to
			the entire TrustedDataObject (TDO), it must never use the
			ExternalEdh child element because the HandlingAssertion will 
			always refer to the object in which it resides.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M33"/>
   <xsl:template match="@*|node()" priority="-2" mode="M33">
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00019-->


	<!--RULE -->
<xsl:template match="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))]"
                 priority="1000"
                 mode="M34">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(descendant::edh:ExternalEdh)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(descendant::edh:ExternalEdh)">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00019][Error] HandlingAssertions with scope containing
			the token [TDC] cannot use the ExternalEdh child element.
			
			Human Readable: When a HandlingAssertion has scope pertaining to
			the entire TrustedDataCollection (TDC), it must never use the
			ExternalEdh child element because the HandlingAssertion will always
			refer to the Collection in which it resides.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M34"/>
   <xsl:template match="@*|node()" priority="-2" mode="M34">
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00020-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject[tdf:ReferenceValuePayload]" priority="1000"
                 mode="M35">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[tdf:ReferenceValuePayload]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00020][Error] For element TrustedDataObject, if element
			ReferenceValuePayload is specified, then there must exist two independent
			HandlingAssertion elements, one with attribute scope specified with a value
			of [TDO] and the other with attribute scope specified with a value of [PAYL].
			
			Human Readable: If a ReferenceValuePayload is used, then the instance
			is not the minimal case and must specify markings for the payload
			and the TDO instance separately.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M35"/>
   <xsl:template match="@*|node()" priority="-2" mode="M35">
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00021-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject[tdf:Assertion]" priority="1000" mode="M36">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject[tdf:Assertion]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00021][Error] For element TrustedDataObject, if any Assertion
			elements are specified, then there must exist two independent 
			HandlingAssertion elements, one with attribute scope specified with a 
			value of [TDO] and the other with attribute scope specified with a 
			value of [PAYL].
			
			
			Human Readable: If any Assertion elements are specified, then the instance
			is not the minimal case and must specify markings for the payload
			and the TDO instance separately.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M36"/>
   <xsl:template match="@*|node()" priority="-2" mode="M36">
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00022-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $notice in tdf:HandlingAssertion//ism:Notice satisfies    ($notice/@ism:classification and    (not($notice/@ism:classification='U') or not($notice/@ism:ownerProducer='USA')))]"
                 priority="1000"
                 mode="M37">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $notice in tdf:HandlingAssertion//ism:Notice satisfies    ($notice/@ism:classification and    (not($notice/@ism:classification='U') or not($notice/@ism:ownerProducer='USA')))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00022][Error] For element TrustedDataObject, if there is
			a single HandlingAssertion element and it contains any ism:Notice 
			elements which specify any ISM attributes other than ism:classification
			with a value of [U] and ism:ownerProducer with a value of [USA], then
			there must exist two independent HandlingAssertion elements, one with
			attribute scope specified with a value of [TDO] and the other with 
			attribute scope specified with a value of [PAYL].
			
			Human Readable: If the single IC-EDH contains classified information 
			within a Notice, then the instance is not the minimal case and must
			specify markings for the payload and the TDO instance separately.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M37"/>
   <xsl:template match="@*|node()" priority="-2" mode="M37">
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00023-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $responsibleEntity in tdf:HandlingAssertion//edh:ResponsibleEntity satisfies    ($responsibleEntity/@ism:classification    and (not($responsibleEntity/@ism:classification='U') or not($responsibleEntity/@ism:ownerProducer='USA')))]"
                 priority="1000"
                 mode="M38">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $responsibleEntity in tdf:HandlingAssertion//edh:ResponsibleEntity satisfies    ($responsibleEntity/@ism:classification    and (not($responsibleEntity/@ism:classification='U') or not($responsibleEntity/@ism:ownerProducer='USA')))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00023][Error] For element TrustedDataObject, if there is
			a single HandlingAssertion element and it contains any edh:ResponsibleEntity 
			elements which specify any ISM attributes other than ism:classification
			with a value of [U] and ism:ownerProducer with a value of [USA], then
			there must exist two independent HandlingAssertion elements, one with
			attribute scope specified with a value of [TDO] and the other with 
			attribute scope specified with a value of [PAYL].
			
			Human Readable: If the single IC-EDH contains classified information 
			within a ResponsibleEntity, then the instance is not the minimal case
			and must specify markings for the payload and the TDO instance separately.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M38"/>
   <xsl:template match="@*|node()" priority="-2" mode="M38">
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>

   <!--PATTERN IC-TDF-ID-00024-->


	<!--RULE -->
<xsl:template match="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $ntk in tdf:HandlingAssertion//ntk:* satisfies    ($ntk/@ism:classification    and (not($ntk/@ism:classification='U') or not($ntk/@ism:ownerProducer='USA')))]"
                 priority="1000"
                 mode="M39">
      <svrl:fired-rule xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                       context="tdf:TrustedDataObject   [count(.//tdf:HandlingAssertion)=1]   [some $ntk in tdf:HandlingAssertion//ntk:* satisfies    ($ntk/@ism:classification    and (not($ntk/@ism:classification='U') or not($ntk/@ism:ownerProducer='USA')))]"/>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])">
               <xsl:attribute name="flag">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>
			[IC-TDF-ID-00024][Error] For element TrustedDataObject, if there is
			a single HandlingAssertion element and it contains any ntk:Access or
			ntk:ExternalAccess lements which specify any ISM attributes other than
			ism:classification with a value of [U] and ism:ownerProducer with a 
			value of [USA], then there must exist two independent HandlingAssertion
			elements, one with attribute scope specified with a value of [TDO] and 
			the other with attribute scope specified with a value of [PAYL].
			
			Human Readable: If the single IC-EDH contains classified information 
			within NTK information, then the instance is not the minimal case
			and must specify markings for the payload and the TDO instance separately.
		</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M39"/>
   <xsl:template match="@*|node()" priority="-2" mode="M39">
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
</xsl:stylesheet>