<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IC-TDF-ID-00022" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
    	[IC-TDF-ID-00022][Error] For element TrustedDataObject, if there is
    	a single HandlingAssertion element and it contains any ism:Notice 
    	elements which specify any ISM attributes other than ism:classification
    	with a value of [U] and ism:ownerProducer with a value of [USA], then
    	there must exist two independent HandlingAssertion elements, one with
    	attribute scope specified with a value of [TDO] and the other with 
    	attribute scope specified with a value of [PAYL].
    	
    	Human Readable: If the single IC-EDH contains classified information 
    	within a Notice, then the instance is not the minimal case and must
    	specify markings for the payload and the TDO instance separately.
    </sch:p>
	<sch:p id="codeDesc">
		For TrustedDataObject elements with a single HandlingAssertion descendant 
		element and any ism:Notice elements which specify any ISM attributes other
		than ism:classification with a value of [U] and ism:ownerProducer with a 
		value of [USA], we ensure that there exists two independent
		HandlingAssertion elements, one of scope [TDO] and one of [PAYL].
	</sch:p>
	<sch:rule context="tdf:TrustedDataObject
		[count(.//tdf:HandlingAssertion)=1]
		[some $notice in tdf:HandlingAssertion//ism:Notice satisfies
			($notice/@ism:classification and
			(not($notice/@ism:classification='U') or not($notice/@ism:ownerProducer='USA')))]">
		<sch:assert
			test="not(tdf:HandlingAssertion[@tdf:scope='TDO PAYL'])"
			flag="error">
			[IC-TDF-ID-00022][Error] For element TrustedDataObject, if there is
			a single HandlingAssertion element and it contains any ism:Notice 
			elements which specify any ISM attributes other than ism:classification
			with a value of [U] and ism:ownerProducer with a value of [USA], then
			there must exist two independent HandlingAssertion elements, one with
			attribute scope specified with a value of [TDO] and the other with 
			attribute scope specified with a value of [PAYL].
			
			Human Readable: If the single IC-EDH contains classified information 
			within a Notice, then the instance is not the minimal case and must
			specify markings for the payload and the TDO instance separately.
		</sch:assert>
    </sch:rule>
</sch:pattern>