<?xml version="1.0" encoding="UTF-8"?>
<?ICEA master?><!-- UNCLASSIFIED -->
<!-- Notices - Distribution Notice:
            This document is being made available by the Intelligence Community Chief Information Officer
            to Federal, State, Local, Tribal, and Foreign Partners and associated contractors. Approval for
            any further distribution must be coordinated via the Intelligence Community Chief Information 
            Officer, Mission Engagement Division at standardssupport@dni.gov-->
<!-- WARNING: 
    Once compiled into an XSLT the result will 
    be the aggregate classification of all the CVES 
    and included .sch files
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:cve="urn:us:gov:ic:cve"
            xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            queryBinding="xslt2">
   <sch:ns uri="http://www.w3.org/2001/XMLSchema" prefix="xsd"/>
   <sch:ns uri="urn:us:gov:ic:ism" prefix="ism"/>
	  <sch:ns uri="urn:us:gov:ic:irm" prefix="irm"/>
	  <sch:ns uri="urn:us:gov:ic:ntk" prefix="ntk"/>
   <sch:ns uri="urn:us:mil:ces:metadata:ddms:4" prefix="ddms"/>
   <sch:ns uri="urn:us:gov:ic:cve" prefix="cve"/>
   <sch:ns uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
   <sch:ns uri="http://www.w3.org/1999/XSL/Transform" prefix="xsl"/>
   <sch:ns uri="date:time:function" prefix="dtf"/>
	  <sch:ns prefix="util" uri="urn:us:gov:ic:irm:xsl:util"/>

   <sch:p id="codeDesc"> This is the root file for the IRM Schematron ruleset. It loads all of the
      required CVEs, declares some variables, and includes all of the Rule .sch files. </sch:p>
	
   <sch:let name="IRM_COMPLIES_WITH"
            value="irm:ICResourceMetadataPackage/@irm:compliesWith"/>	
   <sch:let name="MIN_DISCOVERABLE_OR_GREATER"
            value="util:containsAnyOfTheTokens($IRM_COMPLIES_WITH, ('MIN_DISCOVERABLE'))"/>
   <sch:let name="MIN_ACCESSIBLE_OR_GREATER"
            value="$MIN_DISCOVERABLE_OR_GREATER or util:containsAnyOfTheTokens($IRM_COMPLIES_WITH, ('MIN_ACCESSIBLE'))"/>
	
   <!-- (U) Resources  -->
   <sch:let name="agencyAcronymList"
            value="document('../../CVE/IRM/CVEnumIRMAgencyAcronym.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="compliesWithList"
            value="document('../../CVE/IRM/CVEnumIRMCompliesWith.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="coverageFipsDigraphList"
            value="document('../../CVE/IRM/CVEnumIRMCoverageFIPSDigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="coverageIso3166DigraphList"
            value="document('../../CVE/IRM/CVEnumIRMCoverageISO3166Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="coverageIso3166TrigraphList"
            value="document('../../CVE/IRM/CVEnumIRMCoverageISO3166Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="coverageIso3166-2SubCountryList"
            value="document('../../CVE/IRM/CVEnumIRMCoverageISO3166-2SubCountry.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="iso639DigraphList"
            value="document('../../CVE/IRM/CVEnumIRMISO639Digraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="iso639-2TrigraphList"
            value="document('../../CVE/IRM/CVEnumIRMISO639-2Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="iso639-3TrigraphList"
            value="document('../../CVE/IRM/CVEnumIRMISO639-3Trigraph.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>
   <sch:let name="mimeTypeList"
            value="document('../../CVE/IRM/CVEnumIRMMimeType.xml')//cve:Value"/>
   <sch:let name="compoundCountryCodeQualifierTypeList"
            value="document('../../CVE/IRM/CVEnumIRMCompoundCountryCodeQualifierType.xml')//cve:Value"/>
   <sch:let name="compoundLanguageQualifierTypeList"
            value="document('../../CVE/IRM/CVEnumIRMCompoundLanguageQualifierType.xml')//cve:Value"/>
   <sch:let name="subDisciplineTechniquesV1List"
            value="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplineTechniques.xml')//cve:Value"/>
   <sch:let name="subDisciplineTechniquesList"
            value="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplineTechniques.xml')//cve:Value"/>
   <sch:let name="intelSubDisciplinesList"
            value="document('../../CVE/IRM/CVEnumIRMIntelSubDisciplines.xml')//cve:Value"/>
   <sch:let name="intelDisciplinesList"
            value="document('../../CVE/IRM/CVEnumIRMIntelDisciplines.xml')//cve:Value"/>
   <sch:let name="productionMetricsSubjectList"
            value="document('../../CVE/IRM/CVEnumIRMProductionMetricsSubject.xml')//cve:Value"/>
   <sch:let name="productionMetricsCoverageList"
            value="document('../../CVE/IRM/CVEnumIRMProductionMetricsCoverage.xml')//cve:Value"/>
   <sch:let name="activityList"
            value="document('../../CVE/IRM/CVEnumIRMActivity.xml')//cve:Value"/>
    
	  <sch:let name="executableIndicatorList"
            value="document('../../CVE/IRM/CVEnumIRMExecutableIndicator.xml')//cve:Value"/>
   
	  <sch:let name="maliciousCodeIndicatorList"
            value="document('../../CVE/IRM/CVEnumIRMMaliciousCodeIndicator.xml')//cve:Value"/>
  
    <sch:let name="coveragePrecedenceList"
            value="document('../../CVE/IRM/CVEnumIRMCoveragePrecedence.xml')//cve:Value"/>

   <!-- **************************** -->
   <!-- * General Global Variables * -->
   <!-- **************************** -->
   
   <sch:let name="currentYear" value="year-from-dateTime(current-dateTime())"/>
   <sch:let name="timeZoneRegEx" value="'Z|[\+-]\d{2}:\d{2}'"/>
   <sch:let name="endsWithTimeZoneRegEx" value="concat('^.*',$timeZoneRegEx,'$')"/>
   <sch:let name="startDateTimeTemplate" value="'0001-01-01T00:00:00.000'"/>
   <sch:let name="endDateTimeTemplate" value="'9999-12-01T23:59:59.999'"/>
   <sch:let name="defaultTimeZone" value="'Z'"/>

   <!-- ************************************** -->
   <!-- * Abstract Rule and Pattern Includes * -->
   <!-- ************************************** -->

   <sch:include href="./Lib/ValidateValueExistenceInList.sch"/>
   <sch:include href="./Lib/DateListYearRangeRule.sch"/>
   <sch:include href="./Lib/DateYearRangeRule.sch"/>
   <sch:include href="./Lib/CompareDateTimes.sch"/>
   <sch:include href="./Lib/IsmEnforcement.sch"/>

	  <!-- ************************************* -->
	<!-- * Custom XSLT2 Function Definitions * -->
	<!-- ************************************* -->
	
	<!--
    Returns true if any token in the attribute value matches at least one token in the provided list.
  	-->
	<xsl:function name="util:containsAnyOfTheTokens" as="xs:boolean">
		    <xsl:param name="attribute"/>
		    <xsl:param name="tokenList" as="xs:string+"/>
		    <xsl:value-of select="some $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
	  </xsl:function>
	
	  <!--
		Returns the maximum day of the month for an xs:dateTime as an xs:string.
		@param {xs:dateTime} date The date time from which to get the month
		@returns {xs:string} String representation of the maximum day of the month
	-->
	<xsl:function name="dtf:getMaxDay" as="xs:string">
		    <xsl:param name="date" as="xs:dateTime"/>
		    <xsl:variable name="month" select="number(dtf:getMonth(string($date)))"/>
		    <xsl:choose>
			      <xsl:when test="$month = (1,3,5,7,8,10,12)">
				        <xsl:value-of select="31"/>
			      </xsl:when>
			      <xsl:when test="$month = (4,6,9,11)">
				        <xsl:value-of select="30"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="dtf:isLeapYear(string($date))">
						            <xsl:value-of select="29"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="28"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>

	  <!--
		@param {xs:date} date String representation of a date
		@returns {xs:boolean} Returns true if the date provided occurs in a 
		    leap year; otherwise returns false.
	-->
	<xsl:function name="dtf:isLeapYear" as="xs:boolean">
		    <xsl:param name="date" as="xs:string"/>
		    <xsl:variable name="year" as="xs:integer" select="xs:integer(dtf:getYear($date))"/>
		    <xsl:choose>
			      <xsl:when test="$year mod 100 = 0">
				        <xsl:choose>
					          <xsl:when test="$year mod 400 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:choose>
					          <xsl:when test="$year mod 4 = 0">
						            <xsl:value-of select="true()"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>

	  <!--
		Replaces the day portion of the provided dateTime with the new day provided.
		@param {xs:dateTime} dateTime An xs:dateTime to be updated with new day.
		@param {xs:string} newDayString String representation of day portion of a date.
		@returns {xs:dateTime} Returns new xs:dateTime with updated day portion. 
		leap year; otherwise returns false.
	-->
	<xsl:function name="dtf:replaceDateTimeDay" as="xs:dateTime">
		    <xsl:param name="dateTime" as="xs:dateTime"/>
		    <xsl:param name="newDayString" as="xs:string"/>
		    <xsl:variable name="beforeDay" select="substring(string($dateTime), 1, 8)"/>
		    <xsl:variable name="afterDay" select="substring(string($dateTime), 11)"/>
		    <xsl:value-of select="concat($beforeDay, $newDayString, $afterDay)"/>
	  </xsl:function>

	  <!--
		Returns a string representation of the year portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the year portion of the 
		    date represented by the provided string.
	-->
	<xsl:function name="dtf:getYear" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 1, 4)"/>
	  </xsl:function>

	  <!--
		Returns a string representation of the month portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the month portion of the 
		date represented by the provided string.
	-->
	<xsl:function name="dtf:getMonth" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 6, 2)"/>
	  </xsl:function>

	  <!--
		Returns a string representation of the day portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the day portion of the 
		date represented by the provided string.
	-->
	<xsl:function name="dtf:getDay" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="substring(dtf:removeTimeZone($dateString), 9, 2)"/>
	  </xsl:function>

	  <!--
		Returns a string representation of the timezone portion of the date
		represented by the provided string.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of the timezone portion of
		    the date represented by the provided string.
	-->
	<xsl:function name="dtf:getTimeZone" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateTimeEndingWithTimezone" as="xs:string"
                    select="concat('^.*(',$timeZoneRegEx,')$')"/>
		    <xsl:choose>
			      <xsl:when test="matches($dateString, $dateTimeEndingWithTimezone)">
				        <xsl:value-of select="replace($dateString, $dateTimeEndingWithTimezone, '$1')"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$defaultTimeZone"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>

	  <!--
		Returns true if the year portion of the date represented by the provided
		string contains four (4) digits; otherwise returns false.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} true if the year portion of the date represented by
		    the provided string contains four (4) digits; otherwise returns false.
	-->
	<xsl:function name="dtf:yearPortionHasFourDigits" as="xs:boolean">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx" as="xs:string"
                    select="concat('^\d{4}(',$timeZoneRegEx,')?$')"/>
		    <xsl:variable name="dateStartingWithFourDigitYearRegEx" as="xs:string" select="'^\d{4}-.*$'"/>
		    <xsl:value-of select="matches($dateString, $dateWithOnlyFourDigitYearAndOptionalTimeZoneRegEx) or                            matches($dateString, $dateStartingWithFourDigitYearRegEx)"/>
	  </xsl:function>

	  <!--
		Removes the timezone portion of the date represented by the provided
		string and returns all remaining portions.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:string} String representation of a date without a timezone
		    portion.
	-->
	<xsl:function name="dtf:removeTimeZone" as="xs:string">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:value-of select="replace($dateString, $timeZoneRegEx, '')"/>
	  </xsl:function>

	  <!--
		Uses the template provided to fill in missing portions of the string
		representation of a dateTime provided and returns a full xs:dateTime.
		The dateString provided must not contain a timezone.
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@param {xs:string} dateTemplateString String template of a default date
		    from which to pad missing portions of the dateString parameter.
		@returns {xs:dateTime} An xs:dateTime represented by the string date provided.
	-->
	<xsl:function name="dtf:padDateTimeWithTemplate" as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:param name="dateTemplateString" as="xs:string"/>
		    <xsl:value-of select="concat($dateString, substring($dateTemplateString, string-length(normalize-space($dateString))+1))"/>
	  </xsl:function>

	  <!--
		Returns true if the string provided represents an allowable dateTime
		format; false, otherwise. The allowable dateTime formats are defined
		in the DES for the PUBS.XML specification.
		@returns {xs:boolean} Returns true if the string provided represents an 
		    allowable dateTime format; false, otherwise. 
	-->
	<xsl:function name="dtf:isAllowableDateTimeFormat" as="xs:boolean">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="trimmedInput" as="xs:string" select="normalize-space($input)"/>

		    <!-- year -->
		<xsl:variable name="YYYY" as="xs:string" select="'^\d{4}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <!-- year, month -->
		<xsl:variable name="YYYY-MM" as="xs:string" select="'^\d{4}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <!-- year, month, day -->
		<xsl:variable name="YYYY-MM-DD" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <!-- year, month, day, hour, minute -->
		<xsl:variable name="YYYY-MM-DDThh-mm" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <!-- year, month, day, hour, minute, seconds, optional milliseconds -->
		<xsl:variable name="YYYY-MM-DDThh-mm-ss" as="xs:string"
                    select="'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d{1,3})?(Z|[\+-]\d{2}:\d{2})?$'"/>

		    <xsl:value-of select="    matches($trimmedInput, $YYYY) or    matches($trimmedInput, $YYYY-MM) or    matches($trimmedInput, $YYYY-MM-DD) or    matches($trimmedInput, $YYYY-MM-DDThh-mm) or    matches($trimmedInput, $YYYY-MM-DDThh-mm-ss)    "/>
	  </xsl:function>

	  <!--
		Returns the earliest xs:dateTime possible for the provided string
		representation of a dateTime. Fills in missing portions of the 
		dateTime with the earliest possible values. Default values for missing
		portions:
		MM = 01
		DD = 01
		hh = 00
		mm = 00
		ss = 00
		s  = 000
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:dateTime} The earliest xs:dateTime possible for the 
		    provided string representation of a dateTime.
	-->
	<xsl:function name="dtf:startDate" as="xs:dateTime">
		    <xsl:param name="dateString" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($dateString)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($dateString)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $startDateTimeTemplate)"/>
		    <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
	  </xsl:function>

	  <!--
		Returns the latest xs:dateTime possible for the provided string
		representation of a dateTime. Fills in missing portions of the 
		dateTime with the latest possible values. Default values for missing
		portions:
		MM = 12
		DD = maximum day of the month
		hh = 23
		mm = 59
		ss = 59
		s  = 999
		@param {xs:string} dateString String representation of a date in one
		    of the allowable formats.
		@returns {xs:dateTime} The latest xs:dateTime possible for the 
		    provided string representation of a dateTime.
	-->
	<xsl:function name="dtf:endDate" as="xs:dateTime">
		    <xsl:param name="input" as="xs:string"/>
		    <xsl:variable name="timeZonePortion" select="dtf:getTimeZone($input)"/>
		    <xsl:variable name="dateTimePortion" select="dtf:removeTimeZone($input)"/>
		    <xsl:variable name="outputDate"
                    select="dtf:padDateTimeWithTemplate($dateTimePortion, $endDateTimeTemplate)"/>
		    <xsl:variable name="outputWithCorrectedDay"
                    select="dtf:replaceDateTimeDay($outputDate, dtf:getMaxDay($outputDate))"/>
		    <xsl:choose>
			      <xsl:when test="dtf:getDay($input)">
				        <xsl:value-of select="concat($outputDate, $timeZonePortion)"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="concat($outputWithCorrectedDay, $timeZonePortion)"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:function>

	  <!--
		Calculates the date range implied for both primary and secondary and 
		determines if there is any overlap between the two ranges. Overlap is
		defined as the start of primary date range less than or equal to the 
		end of secondary date range, inclusive, and the start of the secondary
		date range less than or equal to the end of the primary date range.
		Returns true if there is any overlap; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date ranges implied by primary 
		    and secondary overlap at all; otherwise, returns false.
	-->
	<xsl:function name="dtf:overlaps" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
		    <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$primaryStart &lt;= $secondaryEnd and $secondaryStart &lt;= $primaryEnd"/>
	  </xsl:function>

	  <!--
		Determines if the date range implied by the string representation in 
		primary is strictly before the date range implied by the string
		representation in secondary. Returns true if the end of the date
		range implied by primary is less than the start of the date range
		implied by secondary; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    is strictly earlier than the date range implied by secondary; otherwise,
		    returns false.
	-->
	<xsl:function name="dtf:isBefore" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
		    <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
		    <xsl:value-of select="$primaryEnd &lt; $secondaryStart"/>
	  </xsl:function>

	  <!--
		Determines if the date range implied by the string representation in 
		primary is strictly after the date range implied by the string
		representation in secondary. Returns true if the end of the date
		range implied by primary is less than the start of the date range
		implied by secondary; otherwise, returns false.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    is strictly later than the date range implied by secondary; otherwise,
		    returns false.
	-->
	<xsl:function name="dtf:isAfter" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
		    <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
		    <xsl:value-of select="$secondaryEnd &lt; $primaryStart"/>
	  </xsl:function>

	  <!--
		Determines if the date range implied by the string representation in 
		primary satisfies the comparison to the date range implied by secondary
		using the provided comparison operator; otherwise, returns false.
		
		Both primary and secondary must be in one of the allowable formats
		and represent dates with four digits in the year portion.
		@param {xs:string} primary String representation of a date in one
		    of the allowable formats.
		@param {xs:string} secondary String representation of a date in one
		    of the allowable formats.
		@returns {xs:boolean} Returns true if the date range implied by primary 
		    satisfies the comparison to the date range implied by secondary using
		    the provided comparison operator; otherwise, returns false.
	-->
	<xsl:function name="dtf:compareDateTimeRanges" as="xs:boolean">
		    <xsl:param name="primary" as="xs:string"/>
		    <xsl:param name="operator" as="xs:string"/>
		    <xsl:param name="secondary" as="xs:string"/>
		    <xsl:variable name="primaryAndSecondayYearPortionsHaveFourDigits" as="xs:boolean"
                    select="dtf:yearPortionHasFourDigits($primary) and dtf:yearPortionHasFourDigits($secondary)"/>
		    <xsl:choose>
			      <xsl:when test="$primaryAndSecondayYearPortionsHaveFourDigits">
				        <xsl:variable name="primaryStart" as="xs:dateTime" select="dtf:startDate($primary)"/>
				        <xsl:variable name="primaryEnd" as="xs:dateTime" select="dtf:endDate($primary)"/>
				        <xsl:variable name="secondaryStart" as="xs:dateTime" select="dtf:startDate($secondary)"/>
				        <xsl:variable name="secondaryEnd" as="xs:dateTime" select="dtf:endDate($secondary)"/>
				        <xsl:choose>
					<!-- 'Less Than' Edge Case -->
					<!-- 2010-01-01T00:00:00.000Z < 2010 -->
					<xsl:when test="($operator = 'lt' or $operator = '&lt;') and              (($primaryStart = $primaryEnd and $primaryStart = $secondaryStart) or              ($primaryStart = $primaryEnd and $primaryStart = $secondaryEnd) or              ($secondaryStart = $secondaryEnd and $primaryStart = $secondaryStart))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>

					          <!-- 'Greater Than' Edge Case -->
					<!-- 2010-12-31T23:59:59.999Z > 2010 -->
					<xsl:when test="($operator = 'gt' or $operator = '&gt;') and              (($primaryStart = $primaryEnd and $primaryEnd = $secondaryEnd) or              ($primaryStart = $primaryEnd and $primaryEnd = $secondaryStart) or              ($secondaryStart = $secondaryEnd and $primaryEnd = $secondaryEnd))">
						            <xsl:value-of select="false()"/>
					          </xsl:when>

					          <!-- 'Less Than' and 'Less Than or Equal' -->
					<xsl:when test="$operator = 'lt' or $operator = '&lt;' or $operator = '&lt;='">
						            <xsl:value-of select="dtf:isBefore($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>

					          <!-- 'Greater Than' and 'Greater Than or Equal' -->
					<xsl:when test="$operator = 'gt' or $operator = '&gt;' or $operator = '&gt;='">
						            <xsl:value-of select="dtf:isAfter($primary, $secondary) or dtf:overlaps($primary, $secondary)"/>
					          </xsl:when>

					          <!-- Default to false() -->
					<xsl:otherwise>
						            <xsl:value-of select="false()"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="false()"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>

   <!--****************************-->
<!-- (U) IRM ID Rules -->
<!--****************************-->

<!--(U) dateTimeConstraints-->
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00015.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00016.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00017.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00018.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00019.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00020.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00021.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00022.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00023.sch"/>
   <sch:include href="./Rules/dateTimeConstraints/IRM_ID_00024.sch"/>

   <!--(U) ddmsConstraints-->
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00011.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00012.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00013.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00014.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00029.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00030.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00032.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00035.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00037.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00038.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00039.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00055.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00056.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00057.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00058.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00059.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00060.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00061.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00062.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00063.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00064.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00065.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00066.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00067.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00068.sch"/>
   <sch:include href="./Rules/ddmsConstraints/IRM_ID_00069.sch"/>

   <!--(U) globalConstraints-->
   <sch:include href="./Rules/globalConstraints/IRM_ID_00002.sch"/>

   <!--(U) ismConstraints-->
   <sch:include href="./Rules/ismConstraints/IRM_ID_00025.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00026.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00040.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00041.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00042.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00043.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00044.sch"/>
   <sch:include href="./Rules/ismConstraints/IRM_ID_00045.sch"/>

   <!--(U) valueEnumerationConstraints-->
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00001.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00003.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00004.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00005.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00006.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00007.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00008.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00009.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00010.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00027.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00028.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00031.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00033.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00034.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00046.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00047.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00048.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00049.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00050.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00051.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00052.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00053.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00054.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00070.sch"/>
   <sch:include href="./Rules/valueEnumerationConstraints/IRM_ID_00071.sch"/>

   <!--(U) xlinkConstraints-->
   <sch:include href="./Rules/xlinkConstraints/IRM_ID_00036.sch"/>
</sch:schema>