<?xml version="1.0" encoding="UTF-8"?>
<?ICEA abstractPattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!-- 
    $context := an xpath to an element
    $primaryDate := an xpath, relative to $context, to a date to compare against all dates in $secondaryDateList
    $secondaryDateList := a list of xpaths, relative to $context, each to a dates in which to compare against $primaryDate
    $operator := the equality operator to use for comparing each date in $secondaryDateList to $primaryDate
    
    First, we make sure that the primaryDate is an allowable date format. If the primary date is not a valid 
    date format, then we return true because we cannot guarantee the value provided is not allowed. Then, for
    each date in $secondaryDateList we perform the same check for a valid date format and compare the 
    secondaryDate to the primaryDate. To perform comparisons between dates, we use the comparison operator
    contained in the param $operator and make sure that all comparisons between primary and secondary dates
    returns true.
-->
<sch:pattern abstract="true" id="CompareDateTimes" 
    xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    
    <sch:p id="ruleText">
        $ruleText
    </sch:p>
    <sch:p id="codeDesc">
        $codeDesc
    </sch:p>

    <sch:rule context="$context">
        <sch:assert
            test="
            if ($flag = 'warning' and dtf:isAllowableDateTimeFormat(string($primaryDate)))
            then every $secondaryDate in $secondaryDateList satisfies
            		if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))
                then dtf:compareDateTimeRanges(string($primaryDate), $operator, string($secondaryDate))
                else true()
            else true()
            "
            flag="warning">
            <sch:value-of select="$ruleText"/>
        </sch:assert>
        <sch:assert
            test="
            if ($flag = 'error' and dtf:isAllowableDateTimeFormat(string($primaryDate)))
            then every $secondaryDate in $secondaryDateList satisfies
	            if(dtf:isAllowableDateTimeFormat(string($secondaryDate)))
	            then dtf:compareDateTimeRanges(string($primaryDate), $operator, string($secondaryDate))
	            else true()
            else true()
            "
            flag="error">
            <sch:value-of select="$ruleText"/>
        </sch:assert>
    </sch:rule>
</sch:pattern>