<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00024" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00024][Warning] For elements ddms:start and ddms:end and attributes 
        @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, 
        @ddms:posted, @ddms:validTil, and @ddms:created, if the time designator (T) 
        is specified, it is recommended that time zone be specified.
        
        Human Readable: For elements and attributes of date-time types, if the 
        time designator (T) is specified, it is recommended that time zone be specified.
    </sch:p>
    
    <sch:p id="codeDesc">
        The pattern applies to ddms:start and ddms:end elements, as well as any element that 
        contains one or more attributes @ddms:approvedOn, @ddms:infoCutOff, @ddms:posted, and 
        @ddms:created. It joins each of these attribute values, if present, into a larger 
        space-separated string. It then breaks this string into tokens at each space character. 
        If the value of the token contains the time zone designator (T), then it makes sure 
        that the token value matches the regular expression for a timeZone, which is defined 
        in the main schema file (IRM_XML.sch).
    </sch:p>

    <!-- Abstract rule, which asserts that if the date $primaryDate specifies the 
        time designator (T), then the timezone is specified -->
    <sch:rule abstract="true" id="abs.rule00024">
        <sch:assert 
            test="
            every $date in $dateList satisfies
                if($date castable as xs:dateTime and contains(string($date),'T'))
                then matches(string($date),$endsWithTimeZoneRegEx)
                else true()"
            flag="warning">
            [IRM-ID-00024][Warning] For elements and attributes of date-time types, if the 
            time designator (T) is specified, it is recommended that time zone be specified.
        </sch:assert>
    </sch:rule>
    
    <!-- Begin using abstract rule on required elements and attributes --> 
    <sch:rule context="ddms:start">
        <sch:let name="dateList" value="."/>
        <sch:extends rule="abs.rule00024"/>
    </sch:rule>

    <sch:rule context="ddms:end">
        <sch:let name="dateList" value="."/>
        <sch:extends rule="abs.rule00024"/>
    </sch:rule>
    
    <sch:rule context="*[@ddms:approvedOn | 
                        @ddms:dateProcessed |
                        @ddms:receivedOn |
                        @ddms:posted | 
                        @ddms:created | 
                        @ddms:infoCutOff | 
                        @ddms:validTil]">
        <sch:let name="dateList" value="
            (@ddms:approvedOn, 
            @ddms:dateProcessed,
            @ddms:receivedOn,
            @ddms:posted,
            @ddms:created,
            @ddms:infoCutOff,
            @ddms:validTil)
            "/>
        <sch:extends rule="abs.rule00024"/>
    </sch:rule>
</sch:pattern>