<?xml version="1.0" encoding="UTF-8"?>
<?ICEA master?><!-- UNCLASSIFIED -->
<!-- Notices - Distribution Notice:
            This document is being made available by the Intelligence Community Chief Information Officer
            to Federal, State, Local, Tribal, and Foreign Partners and associated contractors. Approval for
            any further distribution must be coordinated via the Intelligence Community Chief Information 
            Officer, Mission Engagement Division at standardssupport@dni.gov-->
<!-- WARNING: 
    Once compiled into an XSLT the result will 
    be the aggregate classification of all the CVES 
    and included .sch files
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"
            xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            queryBinding="xslt2">
    <sch:ns prefix="tdf" uri="urn:us:gov:ic:tdf"/>
    <sch:ns prefix="ism" uri="urn:us:gov:ic:ism"/>
    <sch:ns prefix="arh" uri="urn:us:gov:ic:arh"/>
    <sch:ns prefix="edh" uri="urn:us:gov:ic:edh"/>
    <sch:ns prefix="ntk" uri="urn:us:gov:ic:ntk"/>
    <sch:ns prefix="util" uri="urn:us:gov:ic:tdf:xsl:util"/>
    <sch:p id="codeDesc"> This is the root file for the IC-TDF Schematron rule set. It loads all of
        the required CVEs, declares some global variables, and includes all of the Rule .sch files. </sch:p>

    <!--****************************-->
    <!-- (U) Utility functions      -->
    <!--****************************-->

    <!--
    Returns true if any token in the attribute value matches at least one token in the provided list.
  -->
    <xsl:function name="util:containsAnyOfTheTokens" as="xs:boolean">
        <xsl:param name="attribute"/>
        <xsl:param name="tokenList" as="xs:string+"/>
        <xsl:value-of select="some $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
    </xsl:function>

    <!--
		Returns true if every token in the attribute is contained in the provided list.
	-->
    <xsl:function name="util:containsOnlyTheTokens" as="xs:boolean">
        <xsl:param name="attribute"/>
        <xsl:param name="tokenList" as="xs:string+"/>
        <xsl:value-of select="every $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies $attrToken = $tokenList"/>
   </xsl:function>

   <!--****************************-->
<!-- (U) IC-TDF ID Rules -->
<!--****************************-->

<!--(U) appliesToState-->
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00025.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00026.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00027.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00028.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00030.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00031.sch"/>
   <sch:include href="./Rules/appliesToState/IC-TDF_ID_00032.sch"/>

   <!--(U) -->
   <sch:include href="./Rules/IC-TDF_ID_00001.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00002.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00003.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00004.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00005.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00006.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00007.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00008.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00009.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00010.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00011.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00012.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00013.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00014.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00015.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00016.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00017.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00018.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00019.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00020.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00021.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00022.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00023.sch"/>
   <sch:include href="./Rules/IC-TDF_ID_00024.sch"/>
</sch:schema>
<!-- UNCLASSIFIED -->