<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IC-TDF-ID-00007" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
    	[IC-TDF-ID-00007][Error] For any child element of TrustedDataCollection, 
    	the only allowable tokens for attribute scope are [PAYL], [TDC], or [EXPLICIT].
    	
    	Human Readable: Scopes defined within a TrustedDataCollection must refer
    	to the payload (the list of TDOs), the entire TrustedDataCollection, or
    	be explicitly defined.
    </sch:p>
	<sch:p id="codeDesc">
		For the scope attribute specified on any child element of TrustedDataCollection,
		we make sure that the value only contains the tokens [PAYL], [TDC], or [EXPLICIT].
	</sch:p>
	<sch:rule context="tdf:TrustedDataCollection/*[@tdf:scope]">
		<sch:assert 
			test="util:containsOnlyTheTokens(@tdf:scope, ('PAYL', 'TDC', 'EXPLICIT'))"			
            flag="error">
			[IC-TDF-ID-00007][Error] For any child element of TrustedDataCollection, 
			the only allowable tokens for attribute scope are [PAYL], [TDC], or [EXPLICIT].
			
			Human Readable: Scopes defined within a TrustedDataCollection must refer
			to the payload (the list of TDOs), the TrustedDataCollection itself, or
			be explicitly defined.
        </sch:assert>
    </sch:rule>
</sch:pattern>