<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00030" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00030][Error]
        If attribute @ddms:order is specified with integer value N, there must exist 
        other @ddms:order attributes with values 1 to N-1 with no duplicates.
        
        Human Readable: The values of attribute @ddms:order must be numbered 
        sequentially with no duplicates, beginning at 1.
    </sch:p>
    
    <sch:p id="codeDesc">
        A list, named $orderList, is created containing the value of each order 
        attribute within the document after normalizing to remove extra white-space.
        If the total number of items in $orderList does not equal the number 
        of distinct values in $orderList, then a duplicate exists and we return
        false. Otherwise, we make sure that each number from 1 to N, where N 
        is the number of items in $orderList, is contained within $orderList.
        If each number is contained, then we return true. Otherwise, false.
    </sch:p>
    
		<sch:rule context="ddms:resource[//@ddms:order]">
        <sch:let name="orderList"
            value="tokenize(string-join(//@ddms:order/normalize-space(), ' '), ' ')"/>
        <sch:assert 
            test="(count(distinct-values($orderList)) = count($orderList)
                    and (every $index in 1 to count($orderList) 
                            satisfies index-of($orderList, xs:string($index))))
            "
            flag="error">
            [IRM-ID-00030][Error]
            If attribute @ddms:order is specified with integer value N, there must exist 
            other @ddms:order attributes with values 1 to N-1 with no duplicates.
            
            Human Readable: The values of attribute @ddms:order must be numbered 
            sequentially with no duplicates, beginning at 1.
        </sch:assert>
    </sch:rule>
</sch:pattern>