<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="ISM-ID-00171" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [ISM-ID-00171][Warning] If ISM_CAPCO_RESOURCE and displayOnlyTo is specified on 
        the resource element then all classified portions must specify displayOnlyTo.
        
        Human Readable: USA documents having DISPLAYONLY data at the resource level
        must have all classified portions authorized for DISPLAYONLY.
    </sch:p>
    <sch:p id="codeDesc">
        If the document is an ISM_CAPCO_RESOURCE, the current element is the
        ISM_RESOURCE_ELEMENT, and the ISM_RESOURCE_ELEMENT specifies attribute
        ism:displayOnlyTo, then we make sure that all elements which specify
        attribute ism:classification with a value other than [U] also specify
        the attribute ism:displayOnlyTo.
    </sch:p> 
  <sch:rule context="*[$ISM_CAPCO_RESOURCE
                      and generate-id(.) = generate-id($ISM_RESOURCE_ELEMENT) 
                  		and @ism:displayOnlyTo]">       
        <sch:assert  
            test="every $ele in //* satisfies
                    $ele/@ism:classification[normalize-space() = 'U'] or $ele/@ism:displayOnlyTo"
            flag="warning">
            [ISM-ID-00171][Warning] If ISM_CAPCO_RESOURCE and displayOnlyTo is specified on 
            the resource element then all classified portions must specify displayOnlyTo.
            
            Human Readable: USA documents having DISPLAYONLY data at the resource level
            must have all classified portions authorized for DISPLAYONLY.
        </sch:assert>
    </sch:rule>
</sch:pattern>