<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IC-TDF-ID-00019" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
    	[IC-TDF-ID-00019][Error] HandlingAssertions with scope containing
    	the token [TDC] cannot use the ExternalEdh child element.
    	
    	Human Readable: When a HandlingAssertion has scope pertaining to
    	the entire TrustedDataCollection (TDC), it must never use the
    	ExternalEdh child element because the HandlingAssertion will always
    	refer to the Collection in which it resides.
    </sch:p>
	<sch:p id="codeDesc">
		Where a HandlingAssertion exists with scope containing [TDC], ensure that it does
		not have a child of ExternalEdh.
	</sch:p>
	<sch:rule context="tdf:HandlingAssertion[util:containsAnyOfTheTokens(@tdf:scope, ('TDC'))]">
		<sch:assert
			test="not(descendant::edh:ExternalEdh)"
			flag="error">
			[IC-TDF-ID-00019][Error] HandlingAssertions with scope containing
			the token [TDC] cannot use the ExternalEdh child element.
			
			Human Readable: When a HandlingAssertion has scope pertaining to
			the entire TrustedDataCollection (TDC), it must never use the
			ExternalEdh child element because the HandlingAssertion will always
			refer to the Collection in which it resides.
		</sch:assert>
    </sch:rule>
</sch:pattern>