<?xml version="1.0" encoding="UTF-8"?>
<?ICEA abstractPattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<!--
    This abstract pattern checks that if a particular qualifier is specified on a
    ddms:type element that ism:classification is also specified.
    
    $qualifier   := the qualifier value that requires ism to be present
    $errMsg      := the error message text to display when the assertion fails
    
    Example usage:
    <sch:pattern is-a="DdmsTypeIsmEnforcement" id="IRM_ID_00039" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:param name="ruleText" value=""/>
    <sch:param name="codeDesc" value=""/>
    <sch:param name="context" value="ddms:type[@ddms:qualifier=$qualifier]"/>
    <sch:param name="errMsg" value="'
    [IRM-ID-00039][Error]
    If ddms:type is specified with a qualifier of urn:us:gov:ic:irm:productline then
    ism:classification must also be specified.
    '"/>
    </sch:pattern>
    
    Note: $iso4217TrigraphList is defined in the main document, IRM_XML.xml.
-->
<sch:pattern abstract="true" id="IsmEnforcement" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">$ruleText</sch:p>
    <sch:p id="codeDesc">$codeDesc</sch:p>
    
    <sch:rule context="$context"> 
        <sch:assert
            test="@ism:classification"
            flag="error">
            <sch:value-of select="$errMsg"/>
        </sch:assert>
    </sch:rule>
</sch:pattern>