<?xml version="1.0" encoding="UTF-8"?>
<?ICEA master?><!-- UNCLASSIFIED -->
<!-- Notices - Distribution Notice:
            This document is being made available by the Intelligence Community Chief Information Officer
            to Federal, State, Local, Tribal, and Foreign Partners and associated contractors. Approval for
            any further distribution must be coordinated via the Intelligence Community Chief Information 
            Officer, Mission Engagement Division at standardssupport@dni.gov-->
<!-- WARNING: 
    Once compiled into an XSLT the result will 
    be the aggregate classification of all the CVES 
    and included .sch files
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            queryBinding="xslt2">
    <sch:ns uri="urn:us:gov:ic:pubs" prefix="pubs"/>
    <sch:ns uri="urn:us:gov:ic:cve" prefix="cve"/>
    <sch:ns uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
    <sch:ns uri="urn:us:gov:ic:ism" prefix="ism"/>
    <sch:ns uri="urn:us:gov:ic:ntk" prefix="ntk"/>
    <sch:ns uri="urn:us:gov:ic:edh" prefix="edh"/>
    <sch:ns uri="urn:us:gov:ic:arh" prefix="arh"/>
    <sch:ns uri="urn:us:gov:ic:edh:xsl:util" prefix="util"/>
    <sch:ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>


    <!--====================-->
    <!-- (U) Universal Lets -->
    <!--====================-->
    <sch:let name="countryList"
            value="document('../../CVE/IC-EDH/CVEnumEDHOrganizationsUS.xml')//cve:CVE/cve:Enumeration/cve:Term/cve:Value"/>

    <!--****************************-->
    <!-- (U) Custom XSLT function   -->
    <!--****************************-->

    <!--
    Returns true if any token in the attribute value matches at least one token in the provided list.
  -->
    <xsl:function name="util:containsAnyOfTheTokens" as="xs:boolean">
        <xsl:param name="attribute"/>
        <xsl:param name="tokenList" as="xs:string+"/>
        <xsl:value-of select="       some $attrToken in tokenize(normalize-space(string($attribute)), ' ') satisfies         $attrToken = $tokenList       "/>
   </xsl:function>

   <!--****************************-->
<!-- (U) IC-EDH ID Rules -->
<!--****************************-->

<!--(U) GeneralConstraints-->
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00001.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00002.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00003.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00004.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00005.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00006.sch"/>
   <sch:include href="./Rules/GeneralConstraints/IC-EDH_ID_00007.sch"/>
</sch:schema>