<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?>
<!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00016" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00016][Error] The permissible values for the year range are 1901 through the current
        year for attributes @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, 
        @ddms:posted, and @ddms:created.
        
        Human Readable: Dates must be after 1901 and in the past for @ddms:approvedOn, 
        @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, @ddms:posted, and @ddms:created.
    </sch:p>
    
    <sch:p id="codeDesc">
        This pattern uses abstract rules to consolidate logic. For attributes, 
        we make sure that each date contained within $dateList has a year value
        within the range $minYear and $maxYear, inclusive.
    </sch:p>
    
    <!-- Use abstract rule to handle required attributes -->
    <sch:rule context="*[@ddms:approvedOn |
                       @ddms:dateProcessed |
                       @ddms:receivedOn |
                       @ddms:posted | 
                       @ddms:created | 
                       @ddms:infoCutOff]">
        <sch:let name="minYear" value="1901"/>
        <sch:let name="maxYear" value="$currentYear"/>
        <sch:let name="dateList" value="
            (string(@ddms:approvedOn),
            string(@ddms:dateProcessed),
            string(@ddms:receivedOn),
            string(@ddms:posted),
            string(@ddms:created), 
            string(@ddms:infoCutOff))"/>
        <sch:let name="errMsg" value="'
            [IRM-ID-00016][Error] The permissible values for the year range are 1901 through the current
            year for attributes @ddms:approvedOn, @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, 
            @ddms:posted, and @ddms:created.
            
            Human Readable: Dates must be after 1901 and in the past for @ddms:approvedOn, 
            @ddms:dateProcessed, @ddms:receivedOn, @ddms:infoCutOff, @ddms:posted, and @ddms:created.
            '"/>
        <sch:extends rule="abs.dateListYearRangeRule"/>
    </sch:rule>
</sch:pattern>