<?xml version="1.0" encoding="UTF-8"?>
<?ICEA pattern?> 
 <!-- Notices - Distribution Notice: 
           This document has been approved for Public Release and is available for use without restriction.
       -->
<sch:pattern id="IRM-ID-00037" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
    <sch:p id="ruleText">
        [IRM-ID-00037][Error]
        For elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact, if the attribute ism:pocType is specified with
        a value of [ORCON], then the element ddms:phone must be specified with a
        non-whitespace value.
        
        Human Readable: Elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact must specify a phone number if they are 
        denoted as the POC for an ORIGINATOR CONTROLLED data.
    </sch:p>
    <sch:p id="codeDesc">
        For elements ddms:creator, ddms:publisher, ddms:contributor, 
        and ddms:pointOfContact which specify attribute ism:pocType with a value
        of [ORCON], we make sure that a decendent element specifies element
        ddms:phone with a non-whitespace value.
    </sch:p>
		<sch:rule context="ddms:creator[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |
                		    ddms:publisher[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |
                		    ddms:contributor[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))] |
                		    ddms:pointOfContact[util:containsAnyOfTheTokens(@ism:pocType, ('ORCON'))]">
        <sch:assert 
            test="normalize-space(string(descendant::ddms:phone[1]))"
            flag="error">
            [IRM-ID-00037][Error]
            For elements ddms:creator, ddms:publisher, ddms:contributor, 
            and ddms:pointOfContact, if the attribute ism:pocType is specified with
            a value of [ORCON], then the element ddms:phone must be specified with a
            non-whitespace value.
            
            Human Readable: Elements ddms:creator, ddms:publisher, ddms:contributor, 
            and ddms:pointOfContact must specify a phone number if they are 
            denoted as the POC for an ORIGINATOR CONTROLLED data.
        </sch:assert>
    </sch:rule>
</sch:pattern>